<?php
/**
 * @package Flourish Pro
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
 <div class="blog-post-repeat">  
   
   <?php 
        if (has_post_thumbnail() ){
			echo '<div class="post-thumb">';
            the_post_thumbnail();
			echo '</div>';
		}
    ?>
     
   <header class="entry-header">        
        <div class="postmeta">
          <div class="post-date"> <i class="far fa-clock"></i> <?php echo get_the_date(); ?></div>
                    <div class="post-comment"> <i class="far fa-comments"></i>  <a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></div>
                    <div class="post-categories"> <i class="far fa-folder-open"></i> <?php echo getPostCategories();?></div>
            <div class="clear"></div>
        </div><!-- postmeta -->        
        <h3 class="post-title"><?php the_title(); ?></h3>        
    </header><!-- .entry-header -->

    <div class="entry-content">
        
        <?php the_content(); ?>
        <?php
        wp_link_pages( array(
            'before' => '<div class="page-links">' . __( 'Pages:', 'flourish-pro' ),
            'after'  => '</div>',
        ) );
        ?>
        <div class="postmeta">           
            <div class="post-tags"><?php the_tags(' | Tags: ', ', ', '<br />'); ?> </div>
            <div class="clear"></div>
        </div><!-- postmeta -->
    </div><!-- .entry-content -->
   
    <footer class="entry-meta">
        <?php edit_post_link( __( 'Edit', 'flourish-pro' ), '<span class="edit-link">', '</span>' ); ?>
    </footer><!-- .entry-meta -->
  </div>
</article>