<?php
/**
 * Flourish Pro functions and definitions
 *
 * @package Flourish Pro
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
function content($limit) {
$content = explode(' ', get_the_excerpt(), $limit);
if (count($content)>=$limit) {
array_pop($content);
$content = implode(" ",$content).'...';
} else {
$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content);
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}
//Excerpt limit function
function custom_excerpt_length( $length ) {
	return 100;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

if ( ! function_exists( 'flourish_pro_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function flourish_pro_setup() {

	if ( ! isset( $content_width ) )
		$content_width = 640; /* pixels */

	load_theme_textdomain( 'flourish-pro', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_filter('widget_text', 'do_shortcode');
	add_image_size('homepage-thumb',240,145,true);	
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'flourish-pro' ),
		'footer' => __( 'Footer Menu', 'flourish-pro' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_editor_style( 'editor-style.css' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}
endif; // flourish_pro_setup
add_action( 'after_setup_theme', 'flourish_pro_setup' );

function flourish_pro_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'flourish-pro' ),
		'description'   => __( 'Appears on blog page sidebar', 'flourish-pro' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar Main', 'flourish-pro' ),
		'description'   => __( 'Appears on page sidebar', 'flourish-pro' ),
		'id'            => 'sidebar-main',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Header Widget', 'flourish-pro' ),
		'description'   => __( 'Appears on header', 'flourish-pro' ),
		'id'            => 'header-widget',
		'before_widget' => '<aside id="%1$s" class="header_right headerinfo %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="headwidjet">',
		'after_title'   => '</h5>',
	) );	
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'flourish-pro' ),
		'description'   => __( 'Appears on footer', 'flourish-pro' ),
		'id'            => 'footer-1',
		'before_widget' => '<div id="%1$s" class="widget-column-1">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'flourish-pro' ),
		'description'   => __( 'Appears on footer', 'flourish-pro' ),
		'id'            => 'footer-2',
		'before_widget' => '<div id="%1$s" class="widget-column-2">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'flourish-pro' ),
		'description'   => __( 'Appears on footer', 'flourish-pro' ),
		'id'            => 'footer-3',
		'before_widget' => '<div id="%1$s" class="widget-column-3">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 4', 'flourish-pro' ),
		'description'   => __( 'Appears on footer', 'flourish-pro' ),
		'id'            => 'footer-4',
		'before_widget' => '<div id="%1$s" class="widget-column-4">',
		'after_widget'  => '</div>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
	
	
	register_sidebar( array(
		'name'          => __( 'Sidebar Contact Page', 'flourish-pro' ),
		'description'   => __( 'Appears on contact page', 'flourish-pro' ),
		'id'            => 'sidebar-contact',
		'before_widget' => '<aside class="widget-contact %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="contactinfo-title">',
		'after_title'   => '</h3>',
	) );

}
add_action( 'widgets_init', 'flourish_pro_widgets_init' );

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/inc/' );
require_once get_template_directory() . '/inc/options-framework.php';

function flourish_pro_scripts() {	
	wp_enqueue_style( 'flourish-pro-gfonts-lato', '//fonts.googleapis.com/css?family=Lato:100,100i,300,300i,400,400i,700,700i,900,900i&display=swap' );	
	wp_enqueue_style( 'flourish-pro-gfonts-assistant', '//fonts.googleapis.com/css?family=Assistant:200,300,400,600,700,800&display=swap' );	
	wp_enqueue_style( 'flourish-pro-gfonts-titillium', '//fonts.googleapis.com/css?family=Titillium+Web:200,200i,300,300i,400,400i,600,600i,700,700i,900&display=swap' );	
	wp_enqueue_style( 'flourish-pro-gfonts-merienda', '//fonts.googleapis.com/css?family=Merienda:400,700&display=swap' );	


	if( of_get_option('bodyfontface',true) != '' ){
		wp_enqueue_style( 'flourish-pro-gfonts-body', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('bodyfontface',true)) .'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if( of_get_option('logofontface',true) != '' ){
		wp_enqueue_style( 'flourish-pro-gfonts-logo', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('logofontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('navfontface', true) != '' ) {
		wp_enqueue_style( 'flourish-pro-gfonts-nav', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('navfontface',true)).'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin' );
	}
	if ( of_get_option('headfontface', true) != '' ) {
		wp_enqueue_style( 'flourish-pro-gfonts-heading', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('headfontface',true)) .'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}
	if ( of_get_option('sectiontitlefontface', true) != '' ) {
		wp_enqueue_style( 'economicspro-gfonts-sectiontitle', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('sectiontitlefontface',true)) .'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	} 
	if ( of_get_option('slidetitlefontface', true) != '' ) {
		wp_enqueue_style( 'economicspro-gfonts-slidetitle', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('slidetitlefontface',true)) .'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	} 
	if ( of_get_option('slidedesfontface', true) != '' ) {
		wp_enqueue_style( 'economicspro-gfonts-slidedes', '//fonts.googleapis.com/css?family='.rawurlencode(of_get_option('slidedesfontface',true)) .'&subset=cyrillic,arabic,bengali,cyrillic,cyrillic-ext,devanagari,greek,greek-ext,gujarati,hebrew,latin-ext,tamil,telugu,thai,vietnamese,latin');
	}  	

	wp_enqueue_style( 'flourish-pro-basic-style', get_stylesheet_uri() );
	wp_enqueue_style( 'flourish-pro-editor-style', get_template_directory_uri().'/editor-style.css' );
	wp_enqueue_style( 'flourish-pro-base-style', get_template_directory_uri().'/css/default.css' );	
	if ( is_home() || is_front_page() ) { 
	wp_enqueue_style( 'flourish-pro-nivo-style', get_template_directory_uri().'/css/nivo-slider.css' );
	wp_enqueue_script( 'flourish-pro-nivo-slider', get_template_directory_uri() . '/js/jquery.nivo.slider.js', array('jquery') );
	}	

	wp_enqueue_script( 'flourish-pro-customscripts', get_template_directory_uri() . '/js/custom.js', array('jquery') );	
	wp_enqueue_style( 'flourish-pro-fontawesome-all-style', get_template_directory_uri().'/fontsawesome/css/fontawesome-all.css' );
	wp_enqueue_style( 'flourish-pro-animation', get_template_directory_uri().'/css/animation.css' );
	wp_enqueue_style( 'flourish-pro-hover', get_template_directory_uri().'/css/hover.css' );
	wp_enqueue_style( 'flourish-pro-hover-min', get_template_directory_uri().'/css/hover-min.css' );
	wp_enqueue_script( 'flourish-pro-testimonialsminjs', get_template_directory_uri().'/testimonialsrotator/js/jquery.quovolver.min.js', array('jquery') );	
	wp_enqueue_style( 'flourish-pro-testimonialslider-style', get_template_directory_uri().'/testimonialsrotator/js/tm-rotator.css' );	
	wp_enqueue_style( 'flourish-pro-responsive-style', get_template_directory_uri().'/css/responsive.css' );		
	wp_enqueue_style( 'flourish-pro-owl-style', get_template_directory_uri().'/testimonialsrotator/js/owl.carousel.css' );
	wp_enqueue_script( 'flourish-pro-owljs', get_template_directory_uri().'/testimonialsrotator/js/owl.carousel.js', array('jquery') );
	
	wp_enqueue_script( 'flourish-pro-counterup', get_template_directory_uri().'/counter/js/jquery.counterup.min.js', array('jquery') );
	wp_enqueue_script( 'flourish-pro-waypoints', get_template_directory_uri().'/counter/js/waypoints.min.js', array('jquery') );
	
	// mixitup script
	wp_enqueue_style( 'flourish-pro-mixitup-style', get_template_directory_uri().'/mixitup/style-mixitup.css' );
	wp_enqueue_script( 'flourish-pro-jquery_013-script', get_template_directory_uri() . '/mixitup/jquery_013.js', array('jquery') );
	wp_enqueue_script( 'flourish-pro-jquery_003-script', get_template_directory_uri() . '/mixitup/jquery_003.js', array('jquery') );
	wp_enqueue_script( 'flourish-pro-screen-script', get_template_directory_uri() . '/mixitup/screen.js', array('jquery') );
	// prettyPhoto script
	wp_enqueue_style( 'flourish-pro-prettyphoto-style', get_template_directory_uri().'/mixitup/prettyPhotoe735.css' );
	wp_enqueue_script( 'flourish-pro-prettyphoto-script', get_template_directory_uri() . '/mixitup/jquery.prettyPhoto5152.js', array('jquery') );
	
	//Client Logo Rotator
	wp_enqueue_style( 'flourish-pro-flexiselcss', get_template_directory_uri().'/css/flexiselcss.css' );	
	wp_enqueue_script( 'flourish-pro-flexisel', get_template_directory_uri() . '/js/jquery.flexisel.js', array('jquery') );
	
	//Popup Video
	wp_enqueue_style( 'flourish-pro-youtube-popup', get_template_directory_uri().'/popupvideo/grt-youtube-popup.css' );	
	wp_enqueue_script( 'flourish-pro-youtube-popup', get_template_directory_uri() . '/popupvideo/grt-youtube-popup.js', array('jquery') );	
	
	
	if( of_get_option('scrollanimation',true) != true) {
		wp_enqueue_style( 'flourish-pro-animation-style', get_template_directory_uri().'/css/animation-style.css' );
		wp_enqueue_script( 'flourish-pro-custom-animation', get_template_directory_uri() . '/js/custom-animation.js', array('jquery') );	
	}
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'flourish_pro_scripts' );

function media_css_hook(){
	
	?>
    	
    	<script>
		jQuery(window).bind('scroll', function() {
	var wwd = jQuery(window).width();
	if( wwd > 939 ){
		var navHeight = jQuery( window ).height() - 575;
		<?php if( of_get_option('headstick',true) == true) { ?>
		if (jQuery(window).scrollTop() > navHeight) {
			jQuery(".header").addClass('fixed');
		}else {
			jQuery(".header").removeClass('fixed');
		}
		<?php } ?>
	}
});		
					
jQuery(window).load(function() {   
  jQuery('.owl-carousel').owlCarousel({
    loop:true,	
	autoplay: <?php echo of_get_option('testimonialsautoplay',true); ?>,
	autoplayTimeout: <?php echo of_get_option('testimonialsrotatingspeed',true); ?>,
    margin:30,
    nav:false,
	dots: true,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:1
        },
        1000:{
            items:2
        }
    }
})
    
  });


jQuery(document).ready(function() {
  
  jQuery('.link').on('click', function(event){
    var $this = jQuery(this);
    if($this.hasClass('clicked')){
      $this.removeAttr('style').removeClass('clicked');
    } else{
      $this.css('background','#7fc242').addClass('clicked');
    }
  });
 
});
</script>

<?php if ( is_home() || is_front_page() ) { ?>        
<script>
		jQuery(window).load(function() {
        jQuery('#slider').nivoSlider({
        	effect:'<?php echo of_get_option('slideefect',true); ?>', //sliceDown, sliceDownLeft, sliceUp, sliceUpLeft, sliceUpDown, sliceUpDownLeft, fold, fade, random, slideInRight, slideInLeft, boxRandom, boxRain, boxRainReverse, boxRainGrow, boxRainGrowReverse
		  	animSpeed: <?php echo of_get_option('slideanim',true); ?>,
			pauseTime: <?php echo of_get_option('slidepause',true); ?>,
			directionNav: <?php echo of_get_option('slidenav',true); ?>,
			controlNav: <?php echo of_get_option('slidepage',true); ?>,
			pauseOnHover: <?php echo of_get_option('slidepausehover',true); ?>,
    });
});
</script>
<?php } ?>


<?php     
}
add_action('wp_head','media_css_hook'); 


function flourish_pro_custom_head_codes() { 
	if ( function_exists('of_get_option') ){
		if ( of_get_option('style2', true) != '' ) {
			echo "<style>". esc_html( of_get_option('style2', true) ) ."</style>";
		}
		echo "<style>";		
		if ( of_get_option('bodyfontcolor', true) != '' ) {
			echo 'body, .contact-form-section .address,  .accordion-box .acc-content{color:'. esc_html( of_get_option('bodyfontcolor', true) ) .';}';
		}
		if( of_get_option('bodyfontface', true) != '' || of_get_option('bodyfontsize',true) != ''){
			echo "body{font-family:".of_get_option('bodyfontface')."; font-size:".of_get_option('bodyfontsize',true).";}";
		}
		if( of_get_option('logofontface',true) != '' || of_get_option('logofontcolor',true) != '' || of_get_option('logofontsize',true) != ''){
			echo ".logo h1 {font-family:".of_get_option('logofontface').";color:".of_get_option('logofontcolor',true).";font-size:".of_get_option('logofontsize',true)."}";
		}
		if( of_get_option('logotaglinecolor',true) != '' ){
			echo ".tagline{color:".of_get_option('logotaglinecolor',true).";}";
		}
		if( of_get_option('logoheight',true) != '' ){
			echo ".logo img{height:".of_get_option('logoheight',true)."px;}";
		}				
		
 
		
		if ( of_get_option('menubgcolor', true) != '' ) {
			echo '.sitenav, .mainmenu, .mainmenu .sitenav ul li ul{background:'. esc_html( of_get_option('menubgcolor', true) ) .';}';
			echo '.logo:after{border-bottom-color:'. esc_html( of_get_option('menubgcolor', true) ) .';}';
		}
		
		if ( of_get_option('navfontface', true) != '' || of_get_option('navfontsize',true) != '' ) {
			echo '.sitenav ul{font-family:\''. esc_html( of_get_option('navfontface', true) ) .'\', sans-serif;font-size:'.of_get_option('navfontsize',true).'}';
		}		
		if ( of_get_option('navfontcolor', true) != '' ) {
			echo '.sitenav ul li a, .sitenav ul li.current_page_item ul.sub-menu li a, .sitenav ul li.current-menu-parent ul.sub-menu li a{color:'. esc_html( of_get_option('navfontcolor', true) ) .';}';
		}

		/*this hover color*/
		if( of_get_option('sectiontitlefontface',true) != '' || of_get_option('sectitlesize',true) != '' || of_get_option('sectitlecolor',true) != '' ){
			echo "h2.section_title, .sec_content_main_title{ font-family:".of_get_option('sectiontitlefontface',true)."; font-size:".of_get_option('sectitlesize',true)."; color:".of_get_option('sectitlecolor',true)."; }";
		}
		
		if( of_get_option('sectiontitlefontface',true) != ''  ){
			echo ".welcome_contentcolumn h3 span{ font-family:".of_get_option('sectiontitlefontface',true)."; }";
		}

		if( of_get_option('sectiontitlefontface',true) != '' ){
			echo ".sec_content_sub_title, .welcome_contentcolumn h3{ font-family:".of_get_option('sectiontitlefontface',true)."; }";
		}
		
		
		if ( of_get_option('linkhovercolor', true) != '' ) {
			echo 'a:hover, .slide_toggle a:hover{color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';
		}			
		if( of_get_option('foottitlecolor', true) != '' || of_get_option('ftfontsize', true) != ''  ){
			echo ".footer h5{color:".of_get_option('foottitlecolor', true)."; font-size:".of_get_option('ftfontsize', true)."; }";
		}
										
		if( of_get_option('copycolor', true) != ''){
			echo ".copyright-txt, .design-by ul li a{color:".of_get_option('copycolor',true)."}";
		}
		if( of_get_option('designcolor', true) != ''){
			echo ".design-by{color:".of_get_option('designcolor',true)."}";
		}		
				
		if ( of_get_option('headertopfontcolor', true) != '' ) {
			echo ".infobox span b, .infobox a{ color:".of_get_option('headertopfontcolor',true).";}";
		}
				
		if( of_get_option('headerbgcolor', true) != ''){
			echo ".header{background:". of_get_option('headerbgcolor', true) ."; }";
		}
		
		if( of_get_option('logobgcolor', true) != ''){
			echo ".logo{background:". of_get_option('logobgcolor', true) ."; }";
		}
				
		if( of_get_option('btntxtcolor', true) != ''){
			echo ".button, #commentform input#submit, input.search-submit, .post-password-form input[type=submit], p.read-more a, .pagination ul li span, .pagination ul li a, .headertop .right a, .wpcf7 form input[type='submit'], #sidebar .search-form input.search-submit{ color:". of_get_option('btntxtcolor', true) ."; }";
		}
		if( of_get_option('btntxthvcolor', true) != '' ){
			echo ".button:hover, #commentform input#submit:hover, input.search-submit:hover, .post-password-form input[type=submit]:hover, p.read-more a:hover, .pagination ul li .current, .pagination ul li a:hover,.headertop .right a:hover, .wpcf7 form input[type='submit']:hover{ color:". esc_html( of_get_option('btntxthvcolor', true) ) .";}";
		}		
		if( of_get_option('btntxtcolor', true) != ''){
			echo "a.morebutton, .news-box .poststyle{ color:". of_get_option('btntxtcolor', true) ."; }";
		}
		if( of_get_option('btntxthvcolor', true) != '' ){
			echo "a.morebutton:hover, .news-box .poststyle:hover{ color:". esc_html( of_get_option('btntxthvcolor', true) ) .";}";
		}
		
		if( of_get_option('btnbghvcolor',true) != '' || of_get_option('btntxthvcolor', true) != ''){
			echo "a.buttonstyle1{background-color:".of_get_option('btnbghvcolor',true)."; color:". of_get_option('btntxthvcolor', true) ."; }";
		}
		if( of_get_option('btntxtcolor', true) != '' ){
			echo "a.buttonstyle1:hover{ color:". esc_html( of_get_option('btntxtcolor', true) ) .";}";
		}
			
		if ( of_get_option('widgetboxbgcolor', true) != '' || of_get_option('widgetboxfontcolor', true) != '' ) {
		echo "#sidebar .search-form input.search-field{ background-color:".of_get_option('widgetboxbgcolor', true)."; color:".of_get_option('widgetboxfontcolor', true).";  }";
		}			
		if ( of_get_option('wdgttitleccolor', true) != '' ) {
			echo "h3.widget-title{ color:".of_get_option('wdgttitleccolor', true).";}";
		}				
		if ( of_get_option('footerbgcolor', true) != '' || of_get_option('footdesccolor', true) != '' ) {
		echo "#footer-wrapper{background-color:".of_get_option('footerbgcolor', true)."; color:".of_get_option('footdesccolor', true).";}";
		}
		
		if ( of_get_option('footerbgimage', true) != '') {
		echo "#footer-wrapper{background: url(".of_get_option('footerbgimage', true).") no-repeat center center;}";
		}	

		if ( of_get_option('footdesccolor', true) != '' ) {
			echo ".contactdetail a{color:".of_get_option('footdesccolor', true)."; }";
		}			
			
		
		if( of_get_option('sldpagebg',true) != ''){
			echo ".nivo-controlNav a{background-color:".of_get_option('sldpagebg',true)."}";
		}
		
		if( of_get_option('sidebarliaborder', true) != '' ){
			echo "#sidebar ul li{border-color:".of_get_option('sidebarliaborder',true)."}";
		}	
		if( of_get_option('sidebarfontcolor',true) != '' ){
			echo "#sidebar ul li a{color:".of_get_option('sidebarfontcolor',true)."; }";
		}		
		
		if ( of_get_option('slidetitlefontface', true) != '' || of_get_option('slidetitlecolor', true) != '' || of_get_option('slidetitlefontsize', true) != '') {
		echo ".nivo-caption h2{ font-family:".of_get_option('slidetitlefontface', true)."; color:".of_get_option('slidetitlecolor', true)."; font-size:".of_get_option('slidetitlefontsize', true).";  }";
		}
		
		if ( of_get_option('slidedesfontface', true) != '' || of_get_option('slidedesccolor', true) != '' || of_get_option('slidedescfontsize', true) != '') {
		echo ".nivo-caption p{font-family:".of_get_option('slidedesfontface', true)."; color:".of_get_option('slidedesccolor', true)."; font-size:".of_get_option('slidedescfontsize', true).";}";
		}
		
			
		if ( of_get_option('copylinkshover', true) != '' ) {
		echo ".copyright-wrapper a:hover{ color: ".of_get_option('copylinkshover', true)."; }";
		}	
		
		
		if ( of_get_option('copybgcolor', true) != '' ) {
			echo ".copyright-wrapper{background-color:".of_get_option('copybgcolor', true)."; }";
		}

		
		if ( of_get_option('togglemenucolor', true) != '' ) {
		echo ".toggle a{ color:".of_get_option('togglemenucolor', true)."; }";
		}		
		
/* Heading */
		if( of_get_option('headfontface', true) != '' ){
			echo "h1,h2,h3,h4,h5,h6{ font-family:".of_get_option('headfontface',true)."; }";
		}		
		if ( of_get_option('h1fontsize', true) != '' || of_get_option('h1fontcolor', true) != '' ) {
			echo "h1{ font-size:".of_get_option('h1fontsize', true)."; color:".of_get_option('h1fontcolor', true).";}";
		}
		if ( of_get_option('h2fontsize', true) != '' || of_get_option('h2fontcolor', true) != '' ) {
			echo "h2{ font-size:".of_get_option('h2fontsize', true)."; color:".of_get_option('h2fontcolor', true).";}";
		}		
		if ( of_get_option('h3fontsize', true) != '' || of_get_option('h3fontcolor', true) != '' ) {
			echo "h3{ font-size:".of_get_option('h3fontsize', true)."; color:".of_get_option('h3fontcolor', true).";}";
		}		
		if ( of_get_option('h4fontsize', true) != '' || of_get_option('h4fontcolor', true) != '' ) {
			echo "h4{ font-size:".of_get_option('h4fontsize', true)."; color:".of_get_option('h4fontcolor', true).";}";
		}		
		if ( of_get_option('h5fontsize', true) != '' || of_get_option('h5fontcolor', true) != '' ) {
			echo "h5{font-size:".of_get_option('h5fontsize', true)."; color:".of_get_option('h5fontcolor', true).";}";
		}		
		if ( of_get_option('h6fontsize', true) != '' || of_get_option('h6fontcolor', true) != '' ) {
			echo "h6{ font-size:".of_get_option('h6fontsize', true)."; color:".of_get_option('h6fontcolor', true).";}";
		}
/* Custom editable */
			
		if ( of_get_option('footsocialcolor', true) != '' ) {
			echo ".footer .social-icons a{ color:".of_get_option('footsocialcolor', true)."; }";
		}		
		
		$sliderinfohex = of_get_option('sldarinfobg',true); 
		list($r,$g,$b) = sscanf($sliderinfohex,'#%02x%02x%02x');
		if ( of_get_option('sldarinfobg', true) != '' ) {
			echo ".nivo-caption{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('sldarinfoopacity',true).");}";
		}
		
		$sliderarrowhex = of_get_option('sldarrowbg',true); 
		list($r,$g,$b) = sscanf($sliderarrowhex,'#%02x%02x%02x');
		if ( of_get_option('sldarrowbg', true) != '' ) {
			echo ".nivo-directionNav a{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('sldarrowopacity',true).");}";
		}
				
		if ( of_get_option('galleryfilter', true) != '' || of_get_option('galleryfiltercolor', true) != '' || of_get_option('galleryfilterbdr', true) != '' ) {
			echo "ul.portfoliofilter li a{ background-color:".of_get_option('galleryfilter', true).";  color:".of_get_option('galleryfiltercolor', true)."; border-color:".of_get_option('galleryfilterbdr', true).";}";
		}
		
		if ( of_get_option('galleryfiltercolorhv', true) != '' ) {
			echo "ul.portfoliofilter li a.selected, ul.portfoliofilter li a:hover,ul.portfoliofilter li:hover a{ color:".of_get_option('galleryfiltercolorhv', true)."; }";
		}		
		
		if ( of_get_option('gallerytitlecolorhv', true) != '' ) {
			echo ".holderwrap h5{ color:".of_get_option('gallerytitlecolorhv', true)."; }";
		}
		if ( of_get_option('gallerytitlecolorhv', true) != '' ) {
			echo ".holderwrap h5::after{ background-color:".of_get_option('gallerytitlecolorhv', true)."; }";
		}
		
		// Top Four Boxes CSS 
		
		if ( of_get_option('teamttlfontcolor', true) != '' ) {
			echo ".teammember-list span.title{ color:".of_get_option('teamttlfontcolor', true)."; }";
		}
		if ( of_get_option('teamdegigfontcolor', true) != '' ) {
			echo ".teammember-list cite{ color:".of_get_option('teamdegigfontcolor', true)."; }";
		}			
				
		//Testimonials CSS
		
		if ( of_get_option('testidotsbgcolor', true) != '' ) {
			echo ".owl-controls .owl-dot{ background-color:".of_get_option('testidotsbgcolor', true)."; }";
		}		
		
		if ( of_get_option('testimonialdescriptioncolor', true) != '' ) {
			echo "#clienttestiminials .item{ color:".of_get_option('testimonialdescriptioncolor', true)."; }";
		}
				
				
		if ( of_get_option('footerpoststitlecolor', true) != '' ) {
			echo "ul.recent-post li a{ color:".of_get_option('footerpoststitlecolor', true)."; }";
		}
		
				
				
		
		//Color scheme for one click background color
		if ( of_get_option('colorscheme', true) != '' ) {
			echo ".button, 
			a.morebutton, .news-box .poststyle, 
			#commentform input#submit, 
			input.search-submit, 
			.post-password-form input[type='submit'], 
			p.read-more a, 
			.pagination ul li span, 
			.pagination ul li a, 
			.headertop .right a, 
			.wpcf7 form input[type='submit'],			
			#sidebar .search-form input.search-submit,
			.nivo-controlNav a.active,			
			.counterlist:hover .cntimage,
			.counterlist:hover .cntbutton,
			.offer-1-column .offimgbx,			
			ul.portfoliofilter li a.selected, 
			ul.portfoliofilter li a:hover,
			ul.portfoliofilter li:hover a,
			.holderwrap,
			.pricing_table .tf a,
			.owl-controls .owl-dot.active,
			input.search-submit:hover, 
			.post-password-form input[type=submit]:hover, 
			p.read-more a:hover, 
			.pagination ul li .current, 
			.pagination ul li a:hover,
			.headertop .right a:hover, 
			.wpcf7 form input[type='submit']:hover,		
			.toggle a, .project-thumb, 		
			a.buttonstyle1:hover,		
			.hvr-sweep-to-right::before, .ftrdonatebtn,			
			h2.section_title::after, .header-top, .header-top:after, .sd-search input, .sd-top-bar-nav .sd-search input, .contactnow, .pagemore, .woocommerce ul.products li.product:hover, .copyright-wrapper:before, .clientlogo .client-img{background-color:".of_get_option('colorscheme', true)."; }";
		}	
		
		//Color scheme for one click font color
		if ( of_get_option('colorscheme', true) != '' ) {
			echo ".sitenav ul li a:hover, .sitenav ul li.current_page_item a, .sitenav ul li.current_page_item ul li a:hover, .sitenav ul li.current-menu-parent a, .sitenav ul li:hover, .sitenav ul li.current_page_item ul.sub-menu li a:hover, .sitenav ul li.current-menu-parent ul.sub-menu li a:hover, .sitenav ul li.current-menu-parent ul.sub-menu li.current_page_item a, .sitenav ul li:hover, a, .nivo-caption a.button-slider, .cntbutton,			
			.contactdetail a:hover, 		
			.footer ul li a:hover, 
			.footer ul li.current_page_item a, 
			div.recent-post a:hover,
			.three_column h3,
			.footer .social-icons a:hover,	
			.infobox a:hover,
			.slide_toggle a, 
			.news-box h6 a:hover,
			.blog-post-repeat .postmeta a:hover,
			#sidebar ul li a:hover,
			.teammember-content span,			
			.header_right .social-icons a:hover,
			#clienttestiminials h6,
			.post-title a:hover,
			.bloggridlayout h3.post-title a:hover,			
			#clienttestiminials .item:hover h6,
			a.borderbutton:hover,
			.copyright-txt span, .ourprojectbg h4 span, .sec_content_main_title span, h2.section_title span, .premium-products-content h5{ color:".of_get_option('colorscheme', true)."; }";
		}
		
			
		
		//Color scheme for one click border color
		if ( of_get_option('colorscheme', true) != '' ) {
			echo ".footer .social-icons a:hover,
			ul.portfoliofilter li a.selected, 
			ul.portfoliofilter li a:hover,
			ul.portfoliofilter li:hover a,					
			#clienttestiminials .item span::after,			
			a.borderbutton:hover,
			.welcome_contentcolumn h3::after, 
			h2.section_title:after, 
			.sec_content_main_title:after, 
			.features_left_box .image-shadow:before,
			.premium-products-content h3:after,
			.premium-products-content a.morebutton 
			{ border-color:".of_get_option('colorscheme', true)."; }";
		}
		
		if ( of_get_option('colorscheme', true) != '' ) {			
			echo ".test123{border-bottom-color:".of_get_option('colorscheme', true).";}";
			echo ".sitenav ul li a:hover, 
.sitenav ul li.current-menu-item a,
.sitenav ul li.current-menu-parent a.parent{border-bottom:solid 5px ".of_get_option('colorscheme', true).";}";
		}

		
		if ( of_get_option('allsitehovercolor', true) != '' ) {
			echo ".button:hover, .pagemore:hover, a.morebutton:hover, .news-box .poststyle:hover, 
#commentform input#submit:hover, 
input.search-submit:hover, 
.post-password-form input[type=submit]:hover, 
p.read-more a:hover, 
.pagination ul li .current, 
.pagination ul li a:hover,
.headertop .right a:hover, 
.hvr-radial-out:before,
.wpcf7 form input[type='submit']:hover, .our-process-number, .ourspecialties i, .news-box .postdt, .news-box .news-thumb{ background-color:".of_get_option('allsitehovercolor', true)."; }";
	
	echo ".nivo-caption a.button-slider:hover, .three_column h3:hover, .wel_list i, ul.recent-post li .footerdate, ul.recent-post li a:hover, .design-by ul li a:hover, .design-by ul li.current_page_item a{color:".of_get_option('allsitehovercolor', true).";}";
	}	
	
	echo ".sitenav ul li ul li a:hover, .sitenav ul li ul li a, .sitenav ul li.current_page_item ul.sub-menu li a:hover, 
		.sitenav ul li.current-menu-parent ul.sub-menu li a:hover,
		.sitenav ul li.current-menu-parent ul.sub-menu li.current_page_item a,
		.sitenav ul li.current-menu-parent ul.sub-menu li a.parent.parent-2:hover,
		.sitenav ul li.current-menu-parent ul.sub-menu li ul.sub-menu li a:hover{border-color:".of_get_option('allsitehovercolor', true).";}";
		
		
		echo "</style>";
	}
}
add_action('wp_head', 'flourish_pro_custom_head_codes');


function flourish_pro_pagination() {
	global $wp_query;
	$big = 12345678;
	$page_format = paginate_links( array(
	    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	    'format' => '?paged=%#%',
	    'current' => max( 1, get_query_var('paged') ),
	    'total' => $wp_query->max_num_pages,
	    'type'  => 'array'
	) );
	if( is_array($page_format) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $page_format as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	}
}
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


/**
 * Load custom functions file.
 */
require get_template_directory() . '/inc/custom-functions.php';

function flourish_pro_custom_blogpost_pagination( $wp_query ){
	$big = 999999999; // need an unlikely integer
	if ( get_query_var('paged') ) { $pageVar = 'paged'; }
	elseif ( get_query_var('page') ) { $pageVar = 'page'; }
	else { $pageVar = 'paged'; }
	$pagin = paginate_links( array(
		'base' 			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' 		=> '?'.$pageVar.'=%#%',
		'current' 		=> max( 1, get_query_var($pageVar) ),
		'total' 		=> $wp_query->max_num_pages,
		'prev_text'		=> '&laquo; Prev',
		'next_text' 	=> 'Next &raquo;',
		'type'  => 'array'
	) ); 
	if( is_array($pagin) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $pagin as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	} 
}
// get slug by id
function flourish_pro_get_slug_by_id($id) {
	$post_data = get_post($id, ARRAY_A);
	$slug = $post_data['post_name'];
	return $slug; 
}