<?php         
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */ 

function optionsframework_option_name() {
	// Change this to use your theme slug
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );
	return $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'flourish-pro'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
*/

function optionsframework_options() {
	//array of all custom font types.
	$font_types = array( '' => '',
    'ABeeZee' => 'ABeeZee',
    'Abel' => 'Abel',
    'Abril Fatface' => 'Abril Fatface',
    'Aclonica' => 'Aclonica',
    'Acme' => 'Acme',
    'Actor' => 'Actor',
    'Adamina' => 'Adamina',
    'Advent Pro' => 'Advent Pro',
    'Aguafina Script' => 'Aguafina Script',
    'Akronim' => 'Akronim',
    'Aladin' => 'Aladin',
    'Aldrich' => 'Aldrich',
    'Alegreya' => 'Alegreya',
    'Alegreya Sans SC' => 'Alegreya Sans SC',
    'Alegreya SC' => 'Alegreya SC',
    'Alex Brush' => 'Alex Brush',
    'Alef' => 'Alef',
    'Alfa Slab One' => 'Alfa Slab One',
    'Alice' => 'Alice',
    'Alike' => 'Alike',
    'Alike Angular' => 'Alike Angular',
    'Allan' => 'Allan',
    'Allerta' => 'Allerta',
    'Allerta Stencil' => 'Allerta Stencil',
    'Allura' => 'Allura',
    'Almendra' => 'Almendra',
    'Almendra Display' => 'Almendra Display',
    'Almendra SC' => 'Almendra SC',
    'Amiri' => 'Amiri',
    'Amarante' => 'Amarante',
    'Amaranth' => 'Amaranth',
    'Amatic SC' => 'Amatic SC',
    'Amethysta' => 'Amethysta',
    'Amita' => 'Amita',
    'Anaheim' => 'Anaheim',
    'Andada' => 'Andada',
    'Andika' => 'Andika',
    'Annie Use Your Telescope' => 'Annie Use Your Telescope',
    'Anonymous Pro' => 'Anonymous Pro',
    'Antic' => 'Antic',
    'Antic Didone' => 'Antic Didone',
    'Antic Slab' => 'Antic Slab',
    'Anton' => 'Anton',
    'Angkor' => 'Angkor',
    'Arapey' => 'Arapey',
    'Arbutus' => 'Arbutus',
    'Arbutus Slab' => 'Arbutus Slab',
    'Architects Daughter' => 'Architects Daughter',
    'Archivo White' => 'Archivo White',
    'Archivo Narrow' => 'Archivo Narrow',
    'Arial' => 'Arial',
    'Arimo' => 'Arimo',
    'Arya' => 'Arya',
    'Arizonia' => 'Arizonia',
    'Armata' => 'Armata',
    'Artifika' => 'Artifika',
    'Arvo' => 'Arvo',
    'Asar' => 'Asar',
    'Asap' => 'Asap',
    'Asset' => 'Asset',
	'Assistant' => 'Assistant',
    'Astloch' => 'Astloch',
    'Asul' => 'Asul',
    'Atomic Age' => 'Atomic Age',
    'Aubrey' => 'Aubrey',
    'Audiowide' => 'Audiowide',
    'Autour One' => 'Autour One',
    'Average' => 'Average',
    'Average Sans' => 'Average Sans',
    'Averia Gruesa Libre' => 'Averia Gruesa Libre',
    'Averia Libre' => 'Averia Libre',
    'Averia Sans Libre' => 'Averia Sans Libre',
    'Averia Serif Libre' => 'Averia Serif Libre',
    'Battambang' => 'Battambang',
    'Bad Script' => 'Bad Script',
    'Bayon' => 'Bayon',
    'Balthazar' => 'Balthazar',
    'Bangers' => 'Bangers',
    'Basic' => 'Basic',
    'Baumans' => 'Baumans',
    'Belgrano' => 'Belgrano',
    'Belleza' => 'Belleza',
    'BenchNine' => 'BenchNine',
    'Bentham' => 'Bentham',
    'Berkshire Swash' => 'Berkshire Swash',
    'Bevan' => 'Bevan',
    'Bigelow Rules' => 'Bigelow Rules',
    'Bigshot One' => 'Bigshot One',
    'Bilbo' => 'Bilbo',
    'Bilbo Swash Caps' => 'Bilbo Swash Caps',
    'Biryani' => 'Biryani',
    'Bitter' => 'Bitter',
    'White Ops One' => 'White Ops One',
    'Bokor' => 'Bokor',
    'Bonbon' => 'Bonbon',
    'Boogaloo' => 'Boogaloo',
    'Bowlby One' => 'Bowlby One',
    'Bowlby One SC' => 'Bowlby One SC',
    'Brawler' => 'Brawler',
    'Bree Serif' => 'Bree Serif',
    'Bubblegum Sans' => 'Bubblegum Sans',
    'Bubbler One' => 'Bubbler One',
    'Buda' => 'Buda',
    'Buenard' => 'Buenard',
    'Butcherman' => 'Butcherman',
    'Butcherman Caps' => 'Butcherman Caps',
    'Butterfly Kids' => 'Butterfly Kids',
    'Cabin' => 'Cabin',
    'Cabin Condensed' => 'Cabin Condensed',
    'Cabin Sketch' => 'Cabin Sketch',
    'Cabin' => 'Cabin',
    'Caesar Dressing' => 'Caesar Dressing',
    'Cagliostro' => 'Cagliostro',
    'Calligraffitti' => 'Calligraffitti',
    'Cambay' => 'Cambay',
    'Cambo' => 'Cambo',
    'Candal' => 'Candal',
    'Cantarell' => 'Cantarell',
    'Cantata One' => 'Cantata One',
    'Cantora One' => 'Cantora One',
    'Capriola' => 'Capriola',
    'Cardo' => 'Cardo',
    'Carme' => 'Carme',
    'Carrois Gothic' => 'Carrois Gothic',
    'Carrois Gothic SC' => 'Carrois Gothic SC',
    'Carter One' => 'Carter One',
    'Caveat' => 'Caveat',
    'Caveat Brush' => 'Caveat Brush',
    'Catamaran' => 'Catamaran',
    'Caudex' => 'Caudex',
    'Cedarville Cursive' => 'Cedarville Cursive',
    'Ceviche One' => 'Ceviche One',
    'Changa One' => 'Changa One',
    'Chango' => 'Chango',
    'Chau Philomene One' => 'Chau Philomene One',
    'Chenla' => 'Chenla',
    'Chela One' => 'Chela One',
    'Chelsea Market' => 'Chelsea Market',
    'Cherry Cream Soda' => 'Cherry Cream Soda',
    'Cherry Swash' => 'Cherry Swash',
    'Chewy' => 'Chewy',
    'Chicle' => 'Chicle',
    'Chivo' => 'Chivo',
    'Chonburi' => 'Chonburi',
    'Cinzel' => 'Cinzel',
    'Cinzel Decorative' => 'Cinzel Decorative',
    'Clicker Script' => 'Clicker Script',
    'Coda' => 'Coda',
    'Codystar' => 'Codystar',
    'Combo' => 'Combo',
    'Comfortaa' => 'Comfortaa',
    'Coming Soon' => 'Coming Soon',
    'Condiment' => 'Condiment',
    'Content' => 'Content',
    'Contrail One' => 'Contrail One',
    'Convergence' => 'Convergence',
    'Cookie' => 'Cookie',
    'Comic Sans MS' => 'Comic Sans MS',
    'Copse' => 'Copse',
    'Corben' => 'Corben',
    'Courgette' => 'Courgette',
    'Cousine' => 'Cousine',
    'Coustard' => 'Coustard',
    'Covered By Your Grace' => 'Covered By Your Grace',
    'Crafty Girls' => 'Crafty Girls',
    'Creepster' => 'Creepster',
    'Creepster Caps' => 'Creepster Caps',
    'Crete Round' => 'Crete Round',
    'Crimson' => 'Crimson',
    'Croissant One' => 'Croissant One',
    'Crushed' => 'Crushed',
    'Cuprum' => 'Cuprum',
    'Cutive' => 'Cutive',
    'Cutive Mono' => 'Cutive Mono',
    'Damion' => 'Damion',
    'Dangrek' => 'Dangrek',
    'Dancing Script' => 'Dancing Script',
    'Dawning of a New Day' => 'Dawning of a New Day',
    'Days One' => 'Days One',
    'Dekko' => 'Dekko',
    'Delius' => 'Delius',
    'Delius Swash Caps' => 'Delius Swash Caps',
    'Delius Unicase' => 'Delius Unicase',
    'Della Respira' => 'Della Respira',
    'Denk One' => 'Denk One',
    'Devonshire' => 'Devonshire',
    'Dhurjati' => 'Dhurjati',
    'Didact Gothic' => 'Didact Gothic',
    'Diplomata' => 'Diplomata',
    'Diplomata SC' => 'Diplomata SC',
    'Domine' => 'Domine',
    'Donegal One' => 'Donegal One',
    'Doppio One' => 'Doppio One',
    'Dorsa' => 'Dorsa',
    'Dosis' => 'Dosis',
    'Dr Sugiyama' => 'Dr Sugiyama',
    'Droid Sans' => 'Droid Sans',
    'Droid Sans Mono' => 'Droid Sans Mono',
    'Droid Serif' => 'Droid Serif',
    'Duru Sans' => 'Duru Sans',
    'Dynalight' => 'Dynalight',
    'EB Garamond' => 'EB Garamond',
    'Eczar' => 'Eczar',
    'Eagle Lake' => 'Eagle Lake',
    'Eater' => 'Eater',
    'Eater Caps' => 'Eater Caps',
    'Economica' => 'Economica',
    'Ek Mukta' => 'Ek Mukta',
    'Electrolize' => 'Electrolize',
    'Elsie' => 'Elsie',
    'Elsie Swash Caps' => 'Elsie Swash Caps',
    'Emblema One' => 'Emblema One',
    'Emilys Candy' => 'Emilys Candy',
    'Engagement' => 'Engagement',
    'Englebert' => 'Englebert',
    'Enriqueta' => 'Enriqueta',
    'Erica One' => 'Erica One',
    'Esteban' => 'Esteban',
    'Euphoria Script' => 'Euphoria Script',
    'Ewert' => 'Ewert',
    'Exo' => 'Exo',
    'Exo 2' => 'Exo 2',
    'Expletus Sans' => 'Expletus Sans',
    'Fanwood Text' => 'Fanwood Text',
    'Fascinate' => 'Fascinate',
    'Fascinate Inline' => 'Fascinate Inline',
    'Fasthand' => 'Fasthand',
    'Faster One' => 'Faster One',
    'Federant' => 'Federant',
    'Federo' => 'Federo',
    'Felipa' => 'Felipa',
    'Fenix' => 'Fenix',
    'Finger Paint' => 'Finger Paint',
    'Fira Mono' => 'Fira Mono',
    'Fira Sans' => 'Fira Sans',
    'Fjalla One' => 'Fjalla One',
    'Fjord One' => 'Fjord One',
    'Flamenco' => 'Flamenco',
    'Flavors' => 'Flavors',
    'Fondamento' => 'Fondamento',
    'Fontdiner Swanky' => 'Fontdiner Swanky',
    'Forum' => 'Forum',
    'Francois One' => 'Francois One',
    'FreeSans' => 'FreeSans',

    'Freckle Face' => 'Freckle Face',
    'Fredericka the Great' => 'Fredericka the Great',
    'Fredoka One' => 'Fredoka One',
    'Fresca' => 'Fresca',
    'Freehand' => 'Freehand',
    'Frijole' => 'Frijole',
    'Fruktur' => 'Fruktur',
    'Fugaz One' => 'Fugaz One',
    'Gafata' => 'Gafata',
    'Galdeano' => 'Galdeano',
    'Galindo' => 'Galindo',
    'Gentium Basic' => 'Gentium Basic',
    'Gentium Book Basic' => 'Gentium Book Basic',
    'Geo' => 'Geo',
    'Georgia' => 'Georgia',
    'Geostar' => 'Geostar',
    'Geostar Fill' => 'Geostar Fill',
    'Germania One' => 'Germania One',
    'Gilda Display' => 'Gilda Display',
    'Give You Glory' => 'Give You Glory',
    'Glass Antiqua' => 'Glass Antiqua',
    'Glegoo' => 'Glegoo',
    'Gloria Hallelujah' => 'Gloria Hallelujah',
    'Goblin One' => 'Goblin One',
    'Gochi Hand' => 'Gochi Hand',
    'Gorditas' => 'Gorditas',
    'Gurajada' => 'Gurajada',
    'Goudy Bookletter 1911' => 'Goudy Bookletter 1911',
    'Graduate' => 'Graduate',
    'Grand Hotel' => 'Grand Hotel',
    'Gravitas One' => 'Gravitas One',
    'Great Vibes' => 'Great Vibes',
    'Griffy' => 'Griffy',
    'Gruppo' => 'Gruppo',
    'Gudea' => 'Gudea',
    'Gidugu' => 'Gidugu',
    'GFS Didot' => 'GFS Didot',
    'GFS Neohellenic' => 'GFS Neohellenic',
    'Habibi' => 'Habibi',
    'Hammersmith One' => 'Hammersmith One',
    'Halant' => 'Halant',
    'Hanalei' => 'Hanalei',
    'Hanalei Fill' => 'Hanalei Fill',
    'Handlee' => 'Handlee',
    'Hanuman' => 'Hanuman',
    'Happy Monkey' => 'Happy Monkey',
    'Headland One' => 'Headland One',
    'Henny Penny' => 'Henny Penny',
    'Herr Von Muellerhoff' => 'Herr Von Muellerhoff',
    'Hind' => 'Hind',
    'Hind Siliguri' => 'Hind Siliguri',
    'Hind Vadodara' => 'Hind Vadodara',
    'Holtwood One SC' => 'Holtwood One SC',
    'Homemade Apple' => 'Homemade Apple',
    'Homenaje' => 'Homenaje',
    'IM Fell' => 'IM Fell',
    'Itim' => 'Itim',
    'Iceberg' => 'Iceberg',
    'Iceland' => 'Iceland',
    'Imprima' => 'Imprima',
    'Inconsolata' => 'Inconsolata',
    'Inder' => 'Inder',
    'Indie Flower' => 'Indie Flower',
    'Inknut Antiqua' => 'Inknut Antiqua',
    'Inika' => 'Inika',
    'Irish Growler' => 'Irish Growler',
    'Istok Web' => 'Istok Web',
    'Italiana' => 'Italiana',
    'Italianno' => 'Italianno',
    'Jacques Francois' => 'Jacques Francois',
    'Jacques Francois Shadow' => 'Jacques Francois Shadow',
    'Jim Nightshade' => 'Jim Nightshade',
    'Jockey One' => 'Jockey One',
    'Jaldi' => 'Jaldi',
    'Jolly Lodger' => 'Jolly Lodger',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Sans' => 'Josefin Sans',
    'Josefin Slab' => 'Josefin Slab',
    'Joti One' => 'Joti One',
    'Judson' => 'Judson',
    'Julee' => 'Julee',
    'Julius Sans One' => 'Julius Sans One',
    'Junge' => 'Junge',
    'Jura' => 'Jura',
    'Just Another Hand' => 'Just Another Hand',
    'Just Me Again Down Here' => 'Just Me Again Down Here',
    'Kadwa' => 'Kadwa',
    'Kdam Thmor' => 'Kdam Thmor',
    'Kalam' => 'Kalam', 
    'Kameron' => 'Kameron',
    'Kantumruy' => 'Kantumruy',
    'Karma' => 'Karma',
    'Karla' => 'Karla',
    'Kaushan Script' => 'Kaushan Script',
    'Kavoon' => 'Kavoon',
    'Keania One' => 'Keania One',
    'Kelly Slab' => 'Kelly Slab',
    'Kenia' => 'Kenia',
    'Khand' => 'Khand',
    'Khmer' => 'Khmer',
    'Khula' => 'Khula',
    'Kite One' => 'Kite One',
    'Knewave' => 'Knewave',
    'Kotta One' => 'Kotta One',
    'Kranky' => 'Kranky',
    'Kreon' => 'Kreon',
    'Kristi' => 'Kristi',
    'Koulen' => 'Koulen',
    'Krona One' => 'Krona One',
    'Kurale' => 'Kurale',
    'Lakki Reddy' => 'Lakki Reddy',
    'La Belle Aurore' => 'La Belle Aurore',
    'Lancelot' => 'Lancelot',
    'Laila' => 'Laila',
    'Lato' => 'Lato',
    'Lateef' => 'Lateef',
    'League Script' => 'League Script',
    'Leckerli One' => 'Leckerli One',
    'Ledger' => 'Ledger',
    'Lekton' => 'Lekton',
    'Lemon' => 'Lemon',
    'Libre Baskerville' => 'Libre Baskerville',
    'Life Savers' => 'Life Savers',
    'Lilita One' => 'Lilita One',
    'Limelight' => 'Limelight',
    'Linden Hill' => 'Linden Hill',
    'Lobster' => 'Lobster',
    'Lobster Two' => 'Lobster Two',
    'Londrina Outline' => 'Londrina Outline',
    'Londrina Shadow' => 'Londrina Shadow',
    'Londrina Sketch' => 'Londrina Sketch',
    'Londrina Solid' => 'Londrina Solid',
    'Lora' => 'Lora',
    'Love Ya Like A Sister' => 'Love Ya Like A Sister',
    'Loved by the King' => 'Loved by the King',
    'Lovers Quarrel' => 'Lovers Quarrel',
    'Lucida Sans Unicode' => 'Lucida Sans Unicode',
    'Luckiest Guy' => 'Luckiest Guy',
    'Lusitana' => 'Lusitana',
    'Lustria' => 'Lustria',
    'Macondo' => 'Macondo',
    'Macondo Swash Caps' => 'Macondo Swash Caps',
    'Magra' => 'Magra',
    'Maiden Orange' => 'Maiden Orange',
    'Mallanna' => 'Mallanna',
    'Mandali' => 'Mandali',
    'Mako' => 'Mako',
    'Marcellus' => 'Marcellus',
    'Marcellus SC' => 'Marcellus SC',
    'Marck Script' => 'Marck Script',
    'Margarine' => 'Margarine',
    'Marko One' => 'Marko One',
    'Marmelad' => 'Marmelad',
    'Marvel' => 'Marvel',
    'Martel' => 'Martel',
    'Martel Sans' => 'Martel Sans',
    'Mate' => 'Mate',
    'Mate SC' => 'Mate SC',
    'Maven Pro' => 'Maven Pro',
    'McLaren' => 'McLaren',
    'Meddon' => 'Meddon',
    'MedievalSharp' => 'MedievalSharp',
    'Medula One' => 'Medula One',
    'Megrim' => 'Megrim',
    'Meie Script' => 'Meie Script',
    'Merienda' => 'Merienda',
    'Merienda One' => 'Merienda One',
    'Merriweather' => 'Merriweather',
    'Metal' => 'Metal',
    'Metal Mania' => 'Metal Mania',
    'Metamorphous' => 'Metamorphous',
    'Metrophobic' => 'Metrophobic',
    'Michroma' => 'Michroma',
    'Milonga' => 'Milonga',
    'Miltonian' => 'Miltonian',
    'Miltonian Tattoo' => 'Miltonian Tattoo',
    'Miniver' => 'Miniver',
    'Miss Fajardose' => 'Miss Fajardose',
    'Miss Saint Delafield' => 'Miss Saint Delafield',
    'Modak' => 'Modak',
    'Modern Antiqua' => 'Modern Antiqua',
    'Molengo' => 'Molengo',
    'Molle' => 'Molle',
    'Moulpali' => 'Moulpali',
    'Monda' => 'Monda',
    'Monofett' => 'Monofett',
    'Monoton' => 'Monoton',
    'Monsieur La Doulaise' => 'Monsieur La Doulaise',
    'Montaga' => 'Montaga',
    'Montez' => 'Montez',
    'Montserrat' => 'Montserrat',
    'Montserrat Alternates' => 'Montserrat Alternates',
    'Montserrat Subrayada' => 'Montserrat Subrayada',
    'Mountains of Christmas' => 'Mountains of Christmas',
    'Mouse Memoirs' => 'Mouse Memoirs',
    'Moul' => 'Moul',
    'Mr Bedford' => 'Mr Bedford',
    'Mr Bedfort' => 'Mr Bedfort',
    'Mr Dafoe' => 'Mr Dafoe',
    'Mr De Haviland' => 'Mr De Haviland',
    'Mrs Saint Delafield' => 'Mrs Saint Delafield',
    'Mrs Sheppards' => 'Mrs Sheppards',
    'Muli' => 'Muli',
    'Mystery Quest' => 'Mystery Quest',
    'Neucha' => 'Neucha',
    'Neuton' => 'Neuton',
    'New Rocker' => 'New Rocker',
    'News Cycle' => 'News Cycle',
    'Niconne' => 'Niconne',
    'Nixie One' => 'Nixie One',
    'Nobile' => 'Nobile',
    'Nokora' => 'Nokora',
    'Norican' => 'Norican',
    'Nosifer' => 'Nosifer',
    'Nosifer Caps' => 'Nosifer Caps',
    'Nova Mono' => 'Nova Mono',
    'Noticia Text' => 'Noticia Text',
    'Noto Sans' => 'Noto Sans',
    'Noto Serif' => 'Noto Serif',
    'Nova Round' => 'Nova Round',
    'Numans' => 'Numans',
    'Nunito' => 'Nunito',
    'NTR' => 'NTR',
    'Offside' => 'Offside',
    'Oldenburg' => 'Oldenburg',
    'Oleo Script' => 'Oleo Script',
    'Oleo Script Swash Caps' => 'Oleo Script Swash Caps',
    'Open Sans' => 'Open Sans',
    'Open Sans Condensed' => 'Open Sans Condensed',
    'Oranienbaum' => 'Oranienbaum',
    'Orbitron' => 'Orbitron',
    'Odor Mean Chey' => 'Odor Mean Chey',
    'Oregano' => 'Oregano',
    'Orienta' => 'Orienta',
    'Original Surfer' => 'Original Surfer',
    'Oswald' => 'Oswald',
    'Over the Rainbow' => 'Over the Rainbow',
    'Overlock' => 'Overlock',
    'Overlock SC' => 'Overlock SC',
    'Ovo' => 'Ovo',
    'Oxygen' => 'Oxygen',
    'Oxygen Mono' => 'Oxygen Mono',
    'Palanquin Dark' => 'Palanquin Dark',
    'Peddana' => 'Peddana',
    'Poppins' => 'Poppins',
    'PT Mono' => 'PT Mono',
    'PT Sans' => 'PT Sans',
    'PT Sans Caption' => 'PT Sans Caption',
    'PT Sans Narrow' => 'PT Sans Narrow',
    'PT Serif' => 'PT Serif',
    'PT Serif Caption' => 'PT Serif Caption',
    'Pacifico' => 'Pacifico',
    'Paprika' => 'Paprika',
    'Parisienne' => 'Parisienne',
    'Passero One' => 'Passero One',
    'Passion One' => 'Passion One',
    'Patrick Hand' => 'Patrick Hand',
    'Patrick Hand SC' => 'Patrick Hand SC',
    'Patua One' => 'Patua One',
    'Paytone One' => 'Paytone One',
    'Peralta' => 'Peralta',
    'Permanent Marker' => 'Permanent Marker',
    'Petit Formal Script' => 'Petit Formal Script',
    'Petrona' => 'Petrona',
    'Philosopher' => 'Philosopher',
    'Piedra' => 'Piedra',
    'Pinyon Script' => 'Pinyon Script',
    'Pirata One' => 'Pirata One',
    'Plaster' => 'Plaster',
    'Palatino Linotype' => 'Palatino Linotype',
    'Play' => 'Play',
    'Playball' => 'Playball',
    'Playfair Display' => 'Playfair Display',
    'Playfair Display SC' => 'Playfair Display SC',
    'Podkova' => 'Podkova',
    'Poiret One' => 'Poiret One',
    'Poller One' => 'Poller One',
    'Poly' => 'Poly',
    'Pompiere' => 'Pompiere',
    'Pontano Sans' => 'Pontano Sans',
    'Port Lligat Sans' => 'Port Lligat Sans',
    'Port Lligat Slab' => 'Port Lligat Slab',
    'Prata' => 'Prata',
    'Pragati Narrow' => 'Pragati Narrow',
    'Preahvihear' => 'Preahvihear',
    'Press Start 2P' => 'Press Start 2P',
    'Princess Sofia' => 'Princess Sofia',
    'Prociono' => 'Prociono',
    'Prosto One' => 'Prosto One',
    'Puritan' => 'Puritan',
    'Purple Purse' => 'Purple Purse',
    'Quando' => 'Quando',
    'Quantico' => 'Quantico',
    'Quattrocento' => 'Quattrocento',
    'Quattrocento Sans' => 'Quattrocento Sans',
    'Questrial' => 'Questrial',
    'Quicksand' => 'Quicksand',
    'Quintessential' => 'Quintessential',
    'Qwigley' => 'Qwigley',
    'Racing Sans One' => 'Racing Sans One',
    'Radley' => 'Radley',
    'Rajdhani' => 'Rajdhani',
    'Raleway Dots' => 'Raleway Dots',
    'Raleway' => 'Raleway',
    'Rambla' => 'Rambla',
    'Ramabhadra' => 'Ramabhadra',
    'Ramaraja' => 'Ramaraja',
    'Rammetto One' => 'Rammetto One',
    'Ranchers' => 'Ranchers',
    'Rancho' => 'Rancho',
    'Ranga' => 'Ranga',
    'Ravi Prakash' => 'Ravi Prakash',
    'Rationale' => 'Rationale',
    'Redressed' => 'Redressed',
    'Reenie Beanie' => 'Reenie Beanie',
    'Revalia' => 'Revalia',
    'Rhodium Libre' => 'Rhodium Libre',
    'Ribeye' => 'Ribeye',
    'Ribeye Marrow' => 'Ribeye Marrow',
    'Righteous' => 'Righteous',
    'Risque' => 'Risque',
    'Roboto' => 'Roboto',
    'Roboto Condensed' => 'Roboto Condensed',
    'Roboto Mono' => 'Roboto Mono',
    'Roboto Slab' => 'Roboto Slab',
    'Rochester' => 'Rochester',
    'Rock Salt' => 'Rock Salt',
    'Rokkitt' => 'Rokkitt',
    'Romanesco' => 'Romanesco',
    'Ropa Sans' => 'Ropa Sans',
    'Rosario' => 'Rosario',
    'Rosarivo' => 'Rosarivo',
    'Rouge Script' => 'Rouge Script',
    'Rozha One' => 'Rozha One',
    'Rubik' => 'Rubik',
    'Rubik One' => 'Rubik One',
    'Rubik Mono One' => 'Rubik Mono One',
    'Ruda' => 'Ruda',
    'Rufina' => 'Rufina',
    'Ruge Boogie' => 'Ruge Boogie',
    'Ruluko' => 'Ruluko',
    'Rum Raisin' => 'Rum Raisin',
    'Ruslan Display' => 'Ruslan Display',
    'Russo One' => 'Russo One',
    'Ruthie' => 'Ruthie',
    'Rye' => 'Rye',
    'Sacramento' => 'Sacramento',
    'Sail' => 'Sail',
    'Salsa' => 'Salsa',
    'Sanchez' => 'Sanchez',
    'Sancreek' => 'Sancreek',
    'Sahitya' => 'Sahitya',
    'Sansita One' => 'Sansita One',
    'Sarpanch' => 'Sarpanch',
    'Sarina' => 'Sarina',
    'Satisfy' => 'Satisfy',
    'Scada' => 'Scada',
    'Scheherazade' => 'Scheherazade',
    'Schoolbell' => 'Schoolbell',
    'Seaweed Script' => 'Seaweed Script',
    'Sarala' => 'Sarala',
    'Sevillana' => 'Sevillana',
    'Seymour One' => 'Seymour One',
    'Shadows Into Light' => 'Shadows Into Light',
    'Shadows Into Light Two' => 'Shadows Into Light Two',
    'Shanti' => 'Shanti',
    'Share' => 'Share',
    'Share Tech' => 'Share Tech',
    'Share Tech Mono' => 'Share Tech Mono',
    'Shojumaru' => 'Shojumaru',
    'Short Stack' => 'Short Stack',
    'Sigmar One' => 'Sigmar One',
    'Suranna' => 'Suranna',
    'Suravaram' => 'Suravaram',
    'Suwannaphum' => 'Suwannaphum',
    'Signika' => 'Signika',
    'Signika Negative' => 'Signika Negative',
    'Simonetta' => 'Simonetta',
    'Siemreap' => 'Siemreap',
    'Sirin Stencil' => 'Sirin Stencil',
    'Six Caps' => 'Six Caps',
    'Skranji' => 'Skranji',
    'Slackey' => 'Slackey',
    'Smokum' => 'Smokum',
    'Smythe' => 'Smythe',
    'Sniglet' => 'Sniglet',
    'Snippet' => 'Snippet',
    'Snowburst One' => 'Snowburst One',
    'Sofadi One' => 'Sofadi One',
    'Sofia' => 'Sofia',
    'Sonsie One' => 'Sonsie One',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Sorts Mill Goudy' => 'Sorts Mill Goudy',
    'Source Code Pro' => 'Source Code Pro',
    'Source Sans Pro' => 'Source Sans Pro',
    'Special I am one' => 'Special I am one',
    'Spicy Rice' => 'Spicy Rice',
    'Spinnaker' => 'Spinnaker',
    'Spirax' => 'Spirax',
    'Squada One' => 'Squada One',
    'Sree Krushnadevaraya' => 'Sree Krushnadevaraya',
    'Stalemate' => 'Stalemate',
    'Stalinist One' => 'Stalinist One',
    'Stardos Stencil' => 'Stardos Stencil',
    'Stint Ultra Condensed' => 'Stint Ultra Condensed',
    'Stint Ultra Expanded' => 'Stint Ultra Expanded',
    'Stoke' => 'Stoke',
    'Stoke' => 'Stoke',
    'Strait' => 'Strait',
    'Sura' => 'Sura',
    'Sumana' => 'Sumana',
    'Sue Ellen Francisco' => 'Sue Ellen Francisco',
    'Sunshiney' => 'Sunshiney',
    'Supermercado One' => 'Supermercado One',
    'Swanky and Moo Moo' => 'Swanky and Moo Moo',
    'Syncopate' => 'Syncopate',
    'Symbol' => 'Symbol',
    'Timmana' => 'Timmana',
    'Taprom' => 'Taprom',
    'Tangerine' => 'Tangerine',
    'Tahoma' => 'Tahoma',
    'Teko' => 'Teko',
    'Telex' => 'Telex',
    'Tenali Ramakrishna' => 'Tenali Ramakrishna',
    'Tenor Sans' => 'Tenor Sans',
    'Terminal Dosis' => 'Terminal Dosis',
    'Terminal Dosis Light' => 'Terminal Dosis Light',
    'Text Me One' => 'Text Me One',
    'The Girl Next Door' => 'The Girl Next Door',
    'Tienne' => 'Tienne',
    'Tillana' => 'Tillana',
    'Tinos' => 'Tinos',
    'Titan One' => 'Titan One',
    'Titillium Web' => 'Titillium Web',
    'Trade Winds' => 'Trade Winds',
    'Trebuchet MS' => 'Trebuchet MS',
    'Trocchi' => 'Trocchi',
    'Trochut' => 'Trochut',
    'Trykker' => 'Trykker',
    'Tulpen One' => 'Tulpen One',
    'Ubuntu' => 'Ubuntu',
    'Ubuntu Condensed' => 'Ubuntu Condensed',
    'Ubuntu Mono' => 'Ubuntu Mono',
    'Ultra' => 'Ultra',
    'Uncial Antiqua' => 'Uncial Antiqua',
    'Underdog' => 'Underdog',
    'Unica One' => 'Unica One',
    'UnifrakturCook' => 'UnifrakturCook',
    'UnifrakturMaguntia' => 'UnifrakturMaguntia',
    'Unkempt' => 'Unkempt',
    'Unlock' => 'Unlock',
    'Unna' => 'Unna',
    'VT323' => 'VT323',
    'Vampiro One' => 'Vampiro One',
    'Varela' => 'Varela',
    'Varela Round' => 'Varela Round',
    'Vast Shadow' => 'Vast Shadow',
    'Vesper Libre' => 'Vesper Libre',
    'Verdana' => 'Verdana',
    'Vibur' => 'Vibur',
    'Vidaloka' => 'Vidaloka',
    'Viga' => 'Viga',
    'Voces' => 'Voces',
    'Volkhov' => 'Volkhov',
    'Vollkorn' => 'Vollkorn',
    'Voltaire' => 'Voltaire',
    'Waiting for the Sunrise' => 'Waiting for the Sunrise',
    'Wallpoet' => 'Wallpoet',
    'Walter Turncoat' => 'Walter Turncoat',
    'Warnes' => 'Warnes',
    'Wellfleet' => 'Wellfleet',
    'Wendy One' => 'Wendy One',
    'Wire One' => 'Wire One',
    'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
    'Yantramanav' => 'Yantramanav',
    'Yellowtail' => 'Yellowtail',
    'Yeseva One' => 'Yeseva One',
    'Yesteryear' => 'Yesteryear',
    'Zeyada' => 'Zeyada'
  );

	//array of all font sizes.
	$font_sizes = array( 
		'10px' => '10px',
		'11px' => '11px',
	);
	
	$options = array();
	$imagepath =  get_template_directory_uri() . '/images/';

	
	for($n=12;$n<=200;$n+=1){
		$font_sizes[$n.'px'] = $n.'px';
	}
	
	// Pull all the pages into an array
	 $options_pages = array();
	 $options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	 $options_pages[''] = 'Select a page:';
	 foreach ($options_pages_obj as $page) {
	  $options_pages[$page->ID] = $page->post_title;
	 }

	// array of section content.
	$section_text = array(	

		1 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'Service We Do',
			'menutitle'		=> 'section1',
			'bgcolor' 		=> '#0e0d0c',
			'bgimage'		=> get_template_directory_uri().'/images/section_bg_1.jpg',
			'class'			=> '',
			'content'		=> '[row][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-1.jpg" title="Residential Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-2.jpg" title="Commercial Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-3.jpg" title="Corporate Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-4.jpg" title="Hospitality Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-5.jpg" title="Restaurant Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][servicewedo image="'.get_template_directory_uri().'/images/service-we-do-6.jpg" title="Industrial Design" description="Dolores sit ipsum velit purus aliquet, massa" link="#"][/row]',
		),		
				
	2 => array(
			'section_sub_title'	=> '',
			'section_title'	=> '',
			'menutitle'		=> 'section2',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[column_content type="planing_leftcontentbox"][section-main-title align="left" title="Welcome to Flourish"]<p><strong>Massa frLorem ipsum dolor sit amet, consectetur adipiscing elit. <br /> Vivamus eu pharetra ex. </strong></p><p>Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo, quis laoreet ante sem sed sapien. Phasellus id convallis ligula. Aliquam erat volutpat. Aliquam erat volutpat. Quisque posuere elit ut efficitur hendrerit. Vestibulum aliquet enim ac eros mattis facilisis. Donec ultrices, diam sed efficitur semper, diam lectus malesuada nisl.</p>[button align="left" name="READ MORE" link="#" target="_self"][/column_content][column_content type="planing_videobox"][custom-video youtubeid="qzNVglQP4ng" cover="'.get_template_directory_uri().'/images/video-cover.png"][/column_content]',
		),
		
		3 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'Featured Projects',
			'menutitle'		=> 'section3',
			'bgcolor' 		=> '#f6f6f6',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[featured-projects image="'.get_template_directory_uri().'/images/featured-projects-1.jpg" subtitle="Decorate" title="Comfort Design" description="Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo." link="#" bgcolor="#1d6fb4" color="#ffffff"][featured-projects image="'.get_template_directory_uri().'/images/featured-projects-2.jpg" subtitle="Bedroom Furniture" title="Latest Styles" description="Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo." link="#" bgcolor="#84b41d" color="#ffffff"][featured-projects image="'.get_template_directory_uri().'/images/featured-projects-3.jpg" subtitle="Unique Models" title="Beautiful Furniture" description="Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo." link="#" bgcolor="#b41d5d" color="#ffffff"][featured-projects image="'.get_template_directory_uri().'/images/featured-projects-4.jpg" subtitle="Luxary Home Design" title="The Modern House" description="Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo." link="#" bgcolor="#1db4a4" color="#ffffff"]'
		),
		
		
		4 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'Our Features',
			'menutitle'		=> 'section4',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[column_content type="features_left_box"]<div class="image-shadow"><img src="'.get_template_directory_uri().'/images/our-features.jpg" class="hvr-grow" /></div>[/column_content][column_content type="features_right_box"][row][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-1.png" title="Maintenance Support" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-2.png" title="Reasonable Price" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-3.png" title="Interior Expertise" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-4.png" title="Quality Materials" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-5.png" title="Guaranteed Works" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][our-specialties color="#353535" icon="'.get_template_directory_uri().'/images/our-features-6.png" title="20 years experience" content="Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis" url="#"][/row][/column_content]',
		),	
		
		5 => array(
			'section_sub_title'	=> '',
			'section_title'	=> '',
			'menutitle'		=> 'section5',
			'bgcolor' 		=> '#ff9c00',
			'bgimage'		=> get_template_directory_uri().'/images/section_bg_5.jpg',
			'class'			=> '',
			'content'		=> '
[column_content type="planing_future_rightcontentbox"][section-main-title align="left" title="Want to know more about us?"]<p>Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis, tortor mi aliquam leo, quis laoreet ante sem sed sapien. Phasellus id convallis ligula. Aliquam erat volutpat. Aliquam erat volutpat.</p>
[list color="#ffffff"]
<li>Pleasant Staff</li>
<li>Convenient Location</li>
<li>Non-standard Offers</li>
[/list]
[/column_content]
[column_content type="planing_future_leftcontentbox"]
[counter value="1058" title="Project Completed"][counter value="3541" title="Happy Clients"][counter value="35" title="Years of Experience"][counter value="10" title="Awards"][/column_content]'
		),
		
		6 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'Our Working Process',
			'menutitle'		=> 'section6',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[working-process icon="'.get_template_directory_uri().'/images/working-process-1.png" title="Meet Customers" description="Discovery is all about learning about you so we can create a space that is a reflection of your own unique design style" bgcolor="#2b2b2b" color="#ffffff"][working-process icon="'.get_template_directory_uri().'/images/working-process-2.png" title="Planning & Research" description="Discovery is all about learning about you so we can create a space that is a reflection of your own unique design style" bgcolor="#e96300" color="#ffffff"][working-process icon="'.get_template_directory_uri().'/images/working-process-3.png" title="Finalize the Design" description="Discovery is all about learning about you so we can create a space that is a reflection of your own unique design style" bgcolor="#ff8b35" color="#ffffff"][space height="40px"]'
		),
		
		7 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'Our Professional Team',
			'menutitle'		=> 'section7',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> get_template_directory_uri().'/images/section_bg_7.jpg',
			'class'			=> '',
			'content'		=> '<p style="text-align:center;">Pharetra ex. Etiam eget diam ligula. Sed at blandit ante. Vivamus feugiat, lacus eu suscipit mattis, tortor <br> mi aliquam leo, quis laoreet ante sem sed sapien</p>[our-team show="4"]'
		),
		
		8 => array(
			'section_sub_title'	=> '',
			'section_title'	=> '',
			'menutitle'		=> 'section8',
			'bgcolor' 		=> '#f8f8f8',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[premium-products subtitle="MADE WITH FINEST MATERIALS" title="Premium Quality Sofa" description="Consectetur adipiscing elit. Vivamus eu pharetra ex. Etiam eget diam ligula. Sed at blandit ante." readmore="BUY NOW" link="#link1"  image="'.get_template_directory_uri().'/images/premium-products.png"]'
		),	
		
		9 => array(
			'section_sub_title'	=> '',
			'section_title'	=> 'From the Finest Brands',
			'menutitle'		=> 'section9',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[subtitle color="#9a9a9a" size="15px" align="center" description="Phasellus id convallis ligula. Aliquam erat volutpat. Aliquam erat volutpat. Quisque posuere elit ut efficitur <br />hendreribulum aliquet enim ac eros mattis facilisis."][recent_products per_page="4" columns="4"]'
		),	
		
		10 => array(
			'section_sub_title'	=> '',
			'section_title'	=> '',
			'menutitle'		=> 'section10',
			'bgcolor' 		=> '#f6f6f6',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '
[column_content type="one_half"]
[section-main-title align="center" title="Clients Projects"][subtitle color="#ffffff" size="15px" align="center" description="Phasellus id convallis ligula. Aliquam erat volutpat. Aliquam erat volutpat. <br />Quisque pom aliquet enim ac eros mattis facilisis."][bgimagebox image="'.get_template_directory_uri().'/images/box-image.jpg"][/column_content]
[column_content type="one_half_last"][client_lists][client image="'.get_template_directory_uri().'/images/client-design-1.jpg" title="Quisque pom aliquet enim eros mattis" link="#"][client image="'.get_template_directory_uri().'/images/client-design-2.jpg" title="Quisque pom aliquet enim eros mattis" link="#"][client image="'.get_template_directory_uri().'/images/client-design-3.jpg" title="Quisque pom aliquet enim eros mattis" link="#"][client image="'.get_template_directory_uri().'/images/client-design-4.jpg" title="Quisque pom aliquet enim eros mattis" link="#"][/client_lists][/column_content]'
		),			
		
	11 => array(
			'section_sub_title'	=> '',
			'section_title'	=> '',
			'menutitle'		=> 'section11',
			'bgcolor' 		=> '#ffffff',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '<div>[contact-details icon="fas fa-map-marker-alt" title="Birmingham, Alaska" info="100 Mainstreet Center" bgcolor="#2b2b2b" color="#ffffff"][contact-details icon="fas fa-phone-volume" title="+1800 123 456789" info="Give us a call" bgcolor="#e96300" color="#ffffff"][contact-details icon="far fa-envelope" title="info@domain.com" info="24/7 online support" bgcolor="#ff8b35" color="#ffffff"]<div>'
		), 
				
	);

	$options = array();

	//Basic Settings
	$options[] = array(
		'name' => __('Basic Settings', 'flourish-pro'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Logo', 'flourish-pro'),
		'desc' => __('Upload your main logo here', 'flourish-pro'),
		'id' => 'logo',
		'class' => '',
		'std'	=> get_template_directory_uri().'/images/logo.png',
		'type' => 'upload');
		
	$options[] = array(		
		'desc' => __('Change your custom logo height', 'flourish-pro'),
		'id' => 'logoheight',
		'std' => '41',
		'type' => 'text');
		
	$options[] = array(	
		'name' => __('Site title & Description', 'flourish-pro'),		
		'desc'	=> __('Check To Show site title and description', 'flourish-pro'),
		'id'	=> 'hide_titledesc',
		'type'	=> 'checkbox',
		'std'	=> '');		
		
	$options[] = array(	
		'name' => __('Layout Option', 'flourish-pro'),		
		'desc'	=> __('Check To View Box Layout ', 'flourish-pro'),
		'id'	=> 'boxlayout',
		'type'	=> 'checkbox',
		'std'	=> '');
			
	$options[] = array(
		'name' => __('Sticky Header', 'flourish-pro'),
		'desc' => __('Check this to show sticky header on scroll', 'flourish-pro'),
		'id' => 'headstick',
		'std' => '',
		'type' => 'checkbox');		
			
	$options[] = array(
		'name' => __('Hide Animation', 'flourish-pro'),
		'desc' => __('Check this to hide animation on scroll', 'flourish-pro'),
		'id' => 'scrollanimation',
		'std' => '',
		'type' => 'checkbox');		

	$options[] = array(
		'name' => __('Custom CSS', 'flourish-pro'),
		'desc' => __('Some Custom Styling for your site. Place any css codes here instead of the style.css file.', 'flourish-pro'),
		'id' => 'style2',
		'std' => '',
		'type' => 'textarea');	

	$options[] = array(
		'name' => __('Header Contact Info', 'flourish-pro'),
		'desc' => __('Edit header contact info from here. NOTE: icon name should be as it is giving by font awesome site(far fa-clock) More social icons can be found at: https://fontawesome.com/icons', 'flourish-pro'),
		'id' => 'headerinfo',
		'std' => '<div class="infobox"><i class="far fa-envelope"></i><span><b>Email Us</b> info@youremailid.com</span></div>
<div class="infobox nonedis"><i class="fas fa-mobile-alt"></i><span>CALL US NOW FOR <br />YOUR TRANSPORT</span></div>
<div class="infobox"><span><h6>1800 123 456789</h6></span></div>',
		'type' => 'textarea');	

	$options[] = array(		
		'desc' => __('Check to hide header top contact info', 'flourish-pro'),
		'id' => 'headinfodata',
		'std' => '',
		'type' => 'checkbox');	

 	$options[] = array(
		'name' => __('Header Search', 'flourish-pro'),
		'desc' => __('Check to hide header search', 'flourish-pro'),
		'id' => 'headerseacrh',
		'std' => '',
		'type' => 'checkbox');	 					

	// font family start 		
	$options[] = array(
		'name' => __('Font Faces', 'flourish-pro'),
		'desc' => __('Select font for the body text', 'flourish-pro'),
		'id' => 'bodyfontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the textual logo', 'flourish-pro'),
		'id' => 'logofontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for the navigation text', 'flourish-pro'),
		'id' => 'navfontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font family for all heading tag.', 'flourish-pro'),
		'id' => 'headfontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );
		
	$options[] = array(
		'desc' => __('Select font for Section title', 'flourish-pro'),
		'id' => 'sectiontitlefontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );		
			
	$options[] = array(
		'desc' => __('Select font for Slide title', 'flourish-pro'),
		'id' => 'slidetitlefontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );	
		
	$options[] = array(
		'desc' => __('Select font for Slide Description', 'flourish-pro'),
		'id' => 'slidedesfontface',
		'type' => 'select',
		'std' => 'Lato',
		'options' => $font_types );	

		
	// font sizes start	
	$options[] = array(
		'name' => __('Font Sizes', 'flourish-pro'),
		'desc' => __('Select font size for body text', 'flourish-pro'),
		'id' => 'bodyfontsize',
		'type' => 'select',
		'std' => '15px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for textual logo', 'flourish-pro'),
		'id' => 'logofontsize',
		'type' => 'select',
		'std' => '36px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for navigation', 'flourish-pro'),
		'id' => 'navfontsize',
		'type' => 'select',
		'std' => '15px',
		'options' => $font_sizes );	

	$options[] = array(
		'desc' => __('Select font size for section title', 'flourish-pro'),
		'id' => 'sectitlesize',
		'type' => 'select',
		'std' => '40px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for footer title', 'flourish-pro'),
		'id' => 'ftfontsize',
		'type' => 'select',
		'std' => '21px',
		'options' => $font_sizes );	

	$options[] = array(
		'desc' => __('Select h1 font size', 'flourish-pro'),
		'id' => 'h1fontsize',
		'std' => '30px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h2 font size', 'flourish-pro'),
		'id' => 'h2fontsize',
		'std' => '28px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h3 font size', 'flourish-pro'),
		'id' => 'h3fontsize',
		'std' => '18px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h4 font size', 'flourish-pro'),
		'id' => 'h4fontsize',
		'std' => '22px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h5 font size', 'flourish-pro'),
		'id' => 'h5fontsize',
		'std' => '20px',
		'type' => 'select',
		'options' => $font_sizes);

	$options[] = array(
		'desc' => __('Select h6 font size', 'flourish-pro'),
		'id' => 'h6fontsize',
		'std' => '14px',
		'type' => 'select',
		'options' => $font_sizes);


	// font colors start

	$options[] = array(
		'name' => __('Site Colors Scheme', 'flourish-pro'),
		'desc' => __('Change the color scheme of hole site', 'flourish-pro'),
		'id' => 'colorscheme',
		'std' => '#e96300',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('change hove/active color scheme for hole site', 'flourish-pro'),
		'id' => 'allsitehovercolor',
		'std' => '#f3a973',
		'type' => 'color');		
		
	$options[] = array(	
		'name' => __('Font Colors', 'flourish-pro'),	
		'desc' => __('Select font color for the body text', 'flourish-pro'),
		'id' => 'bodyfontcolor',
		'std' => '#717171',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for textual logo', 'flourish-pro'),
		'id' => 'logofontcolor',
		'std' => '#353535',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for header top phone,email and contact', 'flourish-pro'),
		'id' => 'headertopfontcolor',
		'std' => '#262626',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for logo tagline', 'flourish-pro'),
		'id' => 'logotaglinecolor',
		'std' => '#666666',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for section title', 'flourish-pro'),
		'id' => 'sectitlecolor',
		'std' => '#353535',
		'type' => 'color');	
	
	$options[] = array(
		'desc' => __('Select font color for navigation', 'flourish-pro'),
		'id' => 'navfontcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for widget title', 'flourish-pro'),
		'id' => 'wdgttitleccolor',
		'std' => '#303030',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer title', 'flourish-pro'),
		'id' => 'foottitlecolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer', 'flourish-pro'),
		'id' => 'footdesccolor',
		'std' => '#c1c0c0',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer left text (copyright)', 'flourish-pro'),
		'id' => 'copycolor',
		'std' => '#ffffff',
		'type' => 'color');
		
/*	$options[] = array(
		'desc' => __('Select font color for footer right text (design by)', 'flourish-pro'),
		'id' => 'designcolor',
		'std' => '#ffffff',
		'type' => 'color');*/

	$options[] = array(
		'desc' => __('Select font hover color for links / anchor tags', 'flourish-pro'),
		'id' => 'linkhovercolor',
		'std' => '#272727',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for sidebar li a', 'flourish-pro'),
		'id' => 'sidebarfontcolor',
		'std' => '#78797c',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover color for footer copyright links', 'flourish-pro'),
		'id' => 'copylinkshover',
		'std' => '#ffffff',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h1 font color', 'flourish-pro'),
		'id' => 'h1fontcolor',
		'std' => '#272727',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select h2 font color', 'flourish-pro'),
		'id' => 'h2fontcolor',
		'std' => '#272727',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h3 font color', 'flourish-pro'),
		'id' => 'h3fontcolor',
		'std' => '#272727',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select h4 font color', 'flourish-pro'),
		'id' => 'h4fontcolor',
		'std' => '#272727',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h5 font color', 'flourish-pro'),
		'id' => 'h5fontcolor',
		'std' => '#272727',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select h6 font color', 'flourish-pro'),
		'id' => 'h6fontcolor',
		'std' => '#272727',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer social icons', 'flourish-pro'),
		'id' => 'footsocialcolor',
		'std' => '#c1c0c0',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for gallery filter ', 'flourish-pro'),
		'id' => 'galleryfiltercolor',
		'std' => '#6e6d6d',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font hover color for gallery filter ', 'flourish-pro'),
		'id' => 'galleryfiltercolorhv',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for photogallery title ', 'flourish-pro'),
		'id' => 'gallerytitlecolorhv',
		'std' => '#ffffff',
		'type' => 'color');			
		
	$options[] = array(
		'desc' => __('Select font color for client testimonilas description', 'flourish-pro'),
		'id' => 'testimonialdescriptioncolor',
		'std' => '#717171',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for sidebar widget box', 'flourish-pro'),
		'id' => 'widgetboxfontcolor',
		'std' => '#6e6d6d',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for footer recent posts', 'flourish-pro'),
		'id' => 'footerpoststitlecolor',
		'std' => '#ababab',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for toggle menu on responsive', 'flourish-pro'),
		'id' => 'togglemenucolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for team member title', 'flourish-pro'),
		'id' => 'teamttlfontcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font color for team member designation', 'flourish-pro'),
		'id' => 'teamdegigfontcolor',
		'std' => '#ffffff',
		'type' => 'color');			
					
		
	// Background start			
	$options[] = array(
		'name' => __('Background Colors', 'flourish-pro'),	
		'desc' => __('Select background color for header', 'flourish-pro'),
		'id' => 'headerbgcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select background color for logo', 'flourish-pro'),
		'id' => 'logobgcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select background color for menu', 'flourish-pro'),
		'id' => 'menubgcolor',
		'std' => '#100e0d',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for footer', 'flourish-pro'),
		'id' => 'footerbgcolor',
		'std' => '#232526',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for footer copyright', 'flourish-pro'),
		'id' => 'copybgcolor',
		'std' => '#080605',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for photogallery filter', 'flourish-pro'),
		'id' => 'galleryfilter',
		'std' => '#f1f1f1',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for client testimonials pager dots', 'flourish-pro'),
		'id' => 'testidotsbgcolor',
		'std' => '#494949',
		'type' => 'color');	
	
	$options[] = array(
		'desc' => __('Select background color for sidebar widget search box', 'flourish-pro'),
		'id' => 'widgetboxbgcolor',
		'std' => '#F0EFEF',
		'type' => 'color');			
	
	// Border colors			
	$options[] = array(	
		'name' => __('Border Colors', 'flourish-pro'),		
		'desc' => __('Select border color for sidebar li a', 'flourish-pro'),
		'id' => 'sidebarliaborder',
		'std' => '#eeeeee',
		'type' => 'color');	
		
	$options[] = array(			
		'desc' => __('Select border color for gallery filter', 'flourish-pro'),
		'id' => 'galleryfilterbdr',
		'std' => '#494949',
		'type' => 'color');	

	// Default Buttons		
	$options[] = array(
		'name' => __('Button Colors', 'flourish-pro'),
		'desc' => __('Select background hover color for default button', 'flourish-pro'),
		'id' => 'btnbghvcolor',
		'std' => '#202020',
		'type' => 'color');		

	$options[] = array(
		'desc' => __('Select font color default button', 'flourish-pro'),
		'id' => 'btntxtcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font hover color for default button', 'flourish-pro'),
		'id' => 'btntxthvcolor',
		'std' => '#ffffff',
		'type' => 'color');

	// Slider Caption colors
	$options[] = array(	
		'name' => __('Slider Caption Colors', 'flourish-pro'),				
		'desc' => __('Select font color for slider title', 'flourish-pro'),
		'id' => 'slidetitlecolor',
		'std' => '#ffffff',
		'type' => 'color');			
		
	$options[] = array(		
		'desc' => __('Select font color for slider description', 'flourish-pro'),
		'id' => 'slidedesccolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
		
	$options[] = array(
		'desc' => __('Select font size for slider title', 'flourish-pro'),
		'id' => 'slidetitlefontsize',
		'type' => 'select',
		'std' => '40px',
		'options' => $font_sizes );
		
	$options[] = array(
		'desc' => __('Select font size for slider description', 'flourish-pro'),
		'id' => 'slidedescfontsize',
		'type' => 'select',
		'std' => '15px',
		'options' => $font_sizes );
		
	// Slider controls colors		
	$options[] = array(
		'name' => __('Slider controls Colors', 'flourish-pro'),
		'desc' => __('Select background color for slider pager', 'flourish-pro'),
		'id' => 'sldpagebg',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background color for slider navigation arrows', 'flourish-pro'),
		'id' => 'sldarrowbg',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background opacity color for header slider navigation arrows', 'flourish-pro'),
		'id' => 'sldarrowopacity',
		'std' => '0.7',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));		
		
	$options[] = array(
		'desc' => __('Select background color for slider caption area', 'flourish-pro'),
		'id' => 'sldarinfobg',
		'std' => '#000000',
		'type' => 'color');	
		
	$options[] = array(		
		'desc' => __('Select background opacity color for header slider caption area', 'flourish-pro'),
		'id' => 'sldarinfoopacity',
		'std' => '0.8',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,));			
		
		
	$options[] = array(	
		'name' => __('Excerpt Lenth', 'flourish-pro'),		
		'desc' => __('Select excerpt length for latest news boxes section', 'flourish-pro'),
		'id' => 'latestnewslength',
		'std' => '23',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Select excerpt length for testimonials section', 'flourish-pro'),
		'id' => 'testimonialsexcerptlength',
		'std' => '25',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Select excerpt length for blog post', 'flourish-pro'),
		'id' => 'blogpostexcerptlength',
		'std' => '45',
		'type' => 'text');
		
	$options[] = array(	
		'name' => __('Read More Custom Text', 'flourish-pro'),		
		'desc' => __('Change read more button text for blog posts section ', 'flourish-pro'),
		'id' => 'blogpostreadmoretext',
		'std' => 'VIEW DETAIL',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change read more button text for latest blog post template', 'flourish-pro'),
		'id' => 'readmoretext_blogtemplates',
		'std' => 'Read more &rarr;',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change Show All Button text for photo gallery section', 'flourish-pro'),
		'id' => 'galleryshowallbtn',
		'std' => 'Show All',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('Change menu word on responsive view', 'flourish-pro'),
		'id' => 'menuwordchange',
		'std' => 'Menu',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Blog Single Layout', 'flourish-pro'),
		'desc' => __('Select layout. eg:Boxed, Wide', 'flourish-pro'),
		'id' => 'singlelayout',
		'type' => 'select',
		'std' => 'singleright',
		'options' => array('singleright'=>'Blog Single Right Sidebar', 'singleleft'=>'Blog Single Left Sidebar', 'sitefull'=>'Blog Single Full Width', 'nosidebar'=>'Blog Single No Sidebar') );	
		
	$options[] = array(
		'name' => __('Team Single Layout', 'flourish-pro'),
		'desc' => __('Select layout. eg:left,right,full', 'flourish-pro'),
		'id' => 'teamsinglelayout',
		'type' => 'select',
		'std' => 'sitefull',
		'options' => array('singleright'=>'Team Single Right Sidebar', 'singleleft'=>'Team Single Left Sidebar', 'sitefull'=>'Team Single Full Width', 'nosidebar'=>'Team Single No Sidebar') );	
		
		
	$options[] = array(
		'name' => __('Woocommerce Page Layout', 'flourish-pro'),
		'desc' => __('Select layout. eg:right-sidebar, left-sidebar, full-width', 'flourish-pro'),
		'id' => 'woocommercelayout',
		'type' => 'select',
		'std' => 'woocommercesitefull',
		'options' => array('woocommerceright'=>'Woocommerce Right Sidebar', 'woocommerceleft'=>'Woocommerce Left Sidebar', 'woocommercesitefull'=>'Woocommerce Full Width') );	
		
	$options[] = array(
		'name' => __('Testimonials Single Layout', 'flourish-pro'),
		'desc' => __('Select layout. eg:left,right,full', 'flourish-pro'),
		'id' => 'testimonialsinglelayout',
		'type' => 'select',
		'std' => 'sitefull',
		'options' => array('singleright'=>'Testimonials Single Right Sidebar', 'singleleft'=>'Testimonials Single Left Sidebar', 'sitefull'=>'Testimonials Single Full Width', 'nosidebar'=>'Testimonials Single No Sidebar') );	
	
	
	$options[] = array(	
		'name' => __('Testimonials Rotating Speed', 'flourish-pro'),	
		'desc' => __('manage testimonials rotating speed.', 'flourish-pro'),
		'id' => 'testimonialsrotatingspeed',
		'std' => '8000',
		'type' => 'text');	
		
	$options[] = array(		
		'desc' => __('True/False Auto play Testimonials.','flourish-pro'),
		'id' => 'testimonialsautoplay',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'True', 'false'=>'False'));			
		

	//Layout Settings
	$options[] = array(
		'name' => __('Sections', 'flourish-pro'),
		'type' => 'heading');
		
	
	
	$options[] = array(	
		'name' => __('Top Three Box Services Section', 'flourish-pro'),
		'desc'	=> __('Three Services box for frontpage section','flourish-pro'),
		'id' 	=> 'box1',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for first box.', 'flourish-pro'),
		'id' => 'boximg1',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Second Services box for frontpage section','flourish-pro'),
		'id' 	=> 'box2',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for second box.', 'flourish-pro'),
		'id' => 'boximg2',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('Third Services box for frontpage section','flourish-pro'),
		'id' 	=> 'box3',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for third box.', 'flourish-pro'),
		'id' => 'boximg3',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
	
	$options[] = array(	
		'desc'	=> __('four services box for frontpage section','flourish-pro'),
		'id' 	=> 'box4',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for three box.', 'flourish-pro'),
		'id' => 'boximg4',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Fifth Services box for frontpage section','flourish-pro'),
		'id' 	=> 'box5',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for fifth box.', 'flourish-pro'),
		'id' => 'boximg5',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
		
	$options[] = array(	
		'desc'	=> __('Six Services box for frontpage section','flourish-pro'),
		'id' 	=> 'box6',
		'type'	=> 'select',
		'options' => $options_pages,
	);
	
	$options[] = array(		
		'desc' => __('upload image for six box.', 'flourish-pro'),
		'id' => 'boximg6',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');	
		
	$options[] = array(		
		'desc' => __('Select excerpt length for services three boxes section', 'flourish-pro'),
		'id' => 'pageboxlength',
		'std' => '15',
		'type' => 'text');			
		
	$options[] = array(	
		'desc' => __('Change button text for services three boxes', 'flourish-pro'),
		'id' => 'readmorebutton',
		'std' => 'READ MORE',
		'type' => 'text');
	
	$options[] = array(			
			'desc'	=> __('Check to hide above our services three column section', 'flourish-pro'),
			'id'	=> 'hidefourbxsec',
			'type'	=> 'checkbox',
			'std'	=> '');
			
	//choose us sectiom start
	$options[] = array(	
		'name' => __('Why You Should Choose Us?', 'flourish-pro'),
		'desc'	=> __('select page for welcome section','flourish-pro'),
		'id' 	=> 'welcomebox',
		'type'	=> 'select',
		'options' => $options_pages,
	);

	$options[] = array(		
		'desc' => __('upload image for Choose Us page', 'flourish-pro'),
		'id' => 'welcomeimg',
		'class' => '',
		'std'	=> '',
		'type' => 'upload');
			
	$options[] = array(	
		'desc' => __('Change list for Choose Us page', 'flourish-pro'),
		'id' => 'welcomeboxlist',
		'std' => '<ul>
<li>Pleasant Staff</li>
<li>Convenient Location</li>
<li>Non-standard Offers</li>
<li>Best Quality</li>
<li>Individual Design</li>
<li>Very Fast Delivery</li>
</ul>',
		'type' => 'textarea');

	$options[] = array(		
		'desc' => __('Select excerpt length for choose us page section', 'flourish-pro'),
		'id' => 'welcomepagelength',
		'std' => '150',
		'type' => 'text');
    			
	$options[] = array(		
		'desc' => __('change read more button text for choose us page section', 'flourish-pro'),
		'id' => 'welcomemorebtn',
		'std' => 'READ MORE',
		'type' => 'text');	

	$options[] = array(			
		'desc'	=> __('Check to hide this section', 'flourish-pro'),
		'id'	=> 'hidewelcomesection',
		'type'	=> 'checkbox',
		'std'	=> '');	//welcome sectiom end				
			
			
	//Section tab
	$options[] = array(
		'name' => __('Number of Sections', 'flourish-pro'),
		'desc' => __('Select number of sections', 'flourish-pro'),
		'id' => 'numsection',
		'type' => 'select',
		'std' => '11',
		'options' => array_combine(range(1,30), range(1,30)) );

	$numsecs = of_get_option( 'numsection', 11 );

	for( $n=1; $n<=$numsecs; $n++){
		$options[] = array(
			'desc' => __("<h3>Section ".$n."</h3>", 'flourish-pro'),
			'class' => 'toggle_title',
			'type' => 'info');

		$options[] = array(
			'name' => __('Section Main Title', 'flourish-pro'),
			'id' => 'sectiontitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_title']) ) ? $section_text[$n]['section_title'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section ID', 'flourish-pro'),
			'desc'	=> __('Enter your section ID here. SECTION ID MUST BE IN SMALL LETTERS ONLY AND DO NOT ADD SPACE OR SYMBOL.', 'flourish-pro'),
			'id' => 'menutitle'.$n,
			'std' => ( ( isset($section_text[$n]['menutitle']) ) ? $section_text[$n]['menutitle'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section Background Color', 'flourish-pro'),
			'desc' => __('Select background color for section', 'flourish-pro'),
			'id' => 'sectionbgcolor'.$n,
			'std' => ( ( isset($section_text[$n]['bgcolor']) ) ? $section_text[$n]['bgcolor'] : '' ),
			'type' => 'color');
			
		$options[] = array(
			'name' => __('Background Image', 'flourish-pro'),
			'id' => 'sectionbgimage'.$n,
			'class' => '',
			'std' => ( ( isset($section_text[$n]['bgimage']) ) ? $section_text[$n]['bgimage'] : '' ),
			'type' => 'upload');

		$options[] = array(
			'name' => __('Section CSS Class', 'flourish-pro'),
			'desc' => __('Set class for this section.', 'flourish-pro'),
			'id' => 'sectionclass'.$n,
			'std' => ( ( isset($section_text[$n]['class']) ) ? $section_text[$n]['class'] : '' ),
			'type' => 'text');
			
		$options[] = array(
			'name'	=> __('Hide Section', 'flourish-pro'),
			'desc'	=> __('Check to hide this section', 'flourish-pro'),
			'id'	=> 'hidesec'.$n,
			'type'	=> 'checkbox',
			'std'	=> '');

		$options[] = array(
			'name' => __('Section Content', 'flourish-pro'),
			'id' => 'sectioncontent'.$n,
			'std' => ( ( isset($section_text[$n]['content']) ) ? $section_text[$n]['content'] : '' ),
			'type' => 'editor');
	}


	//SLIDER SETTINGS
	$options[] = array(
		'name' => __('Homepage Slider', 'flourish-pro'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Inner Page Banner', 'flourish-pro'),
		'desc' => __('Upload inner page banner for site', 'flourish-pro'),
		'id' => 'innerpagebanner',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/inner-banner.jpg",
		'type' => 'upload');
		
		
	$options[] = array(
		'name' => __('Custom Slider Shortcode Area For Home Page', 'flourish-pro'),
		'desc' => __('Enter here your slider shortcode without php tag', 'flourish-pro'),
		'id' => 'customslider',
		'std' => '',
		'type' => 'textarea');		
		
	$options[] = array(
		'name' => __('Slider Effects and Timing', 'flourish-pro'),
		'desc' => __('Select slider effect.','flourish-pro'),
		'id' => 'slideefect',
		'std' => 'random',
		'type' => 'select',
		'options' => array('random'=>'Random', 'fade'=>'Fade', 'fold'=>'Fold', 'sliceDown'=>'Slide Down', 'sliceDownLeft'=>'Slide Down Left', 'sliceUp'=>'Slice Up', 'sliceUpLeft'=>'Slice Up Left', 'sliceUpDown'=>'Slice Up Down', 'sliceUpDownLeft'=>'Slice Up Down Left', 'slideInRight'=>'SlideIn Right', 'slideInLeft'=>'SlideIn Left', 'boxRandom'=>'Box Random', 'boxRain'=>'Box Rain', 'boxRainReverse'=>'Box Rain Reverse', 'boxRainGrow'=>'Box Rain Grow', 'boxRainGrowReverse'=>'Box Rain Grow Reverse' ));
		
	$options[] = array(
		'desc' => __('Animation speed should be multiple of 100.', 'flourish-pro'),
		'id' => 'slideanim',
		'std' => 500,
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add slide pause time.', 'flourish-pro'),
		'id' => 'slidepause',
		'std' => 4000,
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slide Controllers', 'flourish-pro'),
		'desc' => __('Hide/Show Direction Naviagtion of slider.','flourish-pro'),
		'id' => 'slidenav',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Hide/Show pager of slider.','flourish-pro'),
		'id' => 'slidepage',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Pause Slide on Hover.','flourish-pro'),
		'id' => 'slidepausehover',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Yes', 'false'=>'No'));	
		
	$options[] = array(
		'name' => __('Slider Image 1', 'flourish-pro'),
		'desc' => __('First Slide', 'flourish-pro'),
		'id' => 'slide1',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider1.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 1', 'flourish-pro'),
		'id' => 'slidetitle1',
		'std' => 'Good Design For Stylish Living',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc1',
		'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus eu pharetra ex. Etiam eget diam ligula. Sed at blandit ante.',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton1',
		'std' => 'View Details',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl1',
		'std' => '#',
		'type' => 'text');		
		
	
	$options[] = array(
		'name' => __('Slider Image 2', 'flourish-pro'),
		'desc' => __('Second Slide', 'flourish-pro'),
		'class' => '',
		'id' => 'slide2',
		'std' => get_template_directory_uri()."/images/slides/slider2.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 2', 'flourish-pro'),
		'id' => 'slidetitle2',
		'std' => 'Living Space Redefined',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc2',
		'std' => 'Donec in metus lectus. Integer vulputate porta elit, fringilla mollis mag lu Interdum et malesuada fames ac ante ipsum primis in fauci.',
		'type' => 'textarea');	
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton2',
		'std' => 'View Details',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl2',
		'std' => '#',
		'type' => 'text');	
	
	$options[] = array(
		'name' => __('Slider Image 3', 'flourish-pro'),
		'desc' => __('Third Slide', 'flourish-pro'),
		'id' => 'slide3',
		'class' => '',
		'std' => get_template_directory_uri()."/images/slides/slider3.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 3', 'flourish-pro'),
		'id' => 'slidetitle3',
		'std' => 'Handmade Wooden Sopha',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc3',
		'std' => 'Integer vulputate porta elit, consectetur adipiscing elit. Vivamus eu pharetra ex. Etiam eget diam ligula. Sed at blandit ante.',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton3',
		'std' => 'View Details',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl3',
		'std' => '#',
		'type' => 'text');	
	
	$options[] = array(
		'name' => __('Slider Image 4', 'flourish-pro'),
		'desc' => __('Third Slide', 'flourish-pro'),
		'id' => 'slide4',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 4', 'flourish-pro'),
		'id' => 'slidetitle4',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc4',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton4',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl4',
		'std' => '',
		'type' => 'text');				
	
	$options[] = array(
		'name' => __('Slider Image 5', 'flourish-pro'),
		'desc' => __('Fifth Slide', 'flourish-pro'),
		'id' => 'slide5',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 5', 'flourish-pro'),
		'id' => 'slidetitle5',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc5',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton5',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl5',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 6', 'flourish-pro'),
		'desc' => __('Sixth Slide', 'flourish-pro'),
		'id' => 'slide6',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 6', 'flourish-pro'),
		'id' => 'slidetitle6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc6',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton6',
		'std' => '',
		'type' => 'text');		
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 7', 'flourish-pro'),
		'desc' => __('Seventh Slide', 'flourish-pro'),
		'id' => 'slide7',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 7', 'flourish-pro'),
		'id' => 'slidetitle7',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc7',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton7',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl7',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 8', 'flourish-pro'),
		'desc' => __('Eighth Slide', 'flourish-pro'),
		'id' => 'slide8',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 8', 'flourish-pro'),
		'id' => 'slidetitle8',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc8',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton8',
		'std' => '',
		'type' => 'text');		
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl8',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 9', 'flourish-pro'),
		'desc' => __('Ninth Slide', 'flourish-pro'),
		'id' => 'slide9',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 9', 'flourish-pro'),
		'id' => 'slidetitle9',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc9',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton9',
		'std' => '',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl9',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 10', 'flourish-pro'),
		'desc' => __('Tenth Slide', 'flourish-pro'),
		'id' => 'slide10',
		'class' => '',
		'std' => '',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => __('Title 10', 'flourish-pro'),
		'id' => 'slidetitle10',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Description or Tagline', 'flourish-pro'),
		'id' => 'slidedesc10',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Read More Button Text', 'flourish-pro'),
		'id' => 'slidebutton10',
		'std' => '',
		'type' => 'text');			
	
	$options[] = array(
		'desc' => __('Slide Url for Read More Button', 'flourish-pro'),
		'id' => 'slideurl10',
		'std' => '',
		'type' => 'text');
	

	//Footer SETTINGS
	$options[] = array(
		'name' => __('Footer', 'flourish-pro'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Footer Background Image', 'flourish-pro'),
		'desc' => __('Upload footer background image', 'flourish-pro'),
		'id' => 'footerbgimage',
		'class' => '',
		'std'	=> get_template_directory_uri()."/images/footerbg.jpg",
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Footer Layout', 'flourish-pro'),
		'desc' => __('footer Select layout. eg:Column, 1, 2, 3 and 4', 'flourish-pro'),
		'id' => 'footerlayout',
		'type' => 'select',
		'std' => 'fourcolumn',
		'options' => array('onecolumn'=>'Footer 1 column', 'twocolumn'=>'Footer 2 column', 'threecolumn'=>'Footer 3 column', 'fourcolumn'=>'Footer 4 column', ) );			
	
	$options[] = array(
		'name' => __('Footer About company Title', 'flourish-pro'),
		'desc' => __('about company title for footer', 'flourish-pro'),
		'id' => 'abouttitle',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Footer About Logo', 'flourish-pro'),
		'desc' => __('About Logo for footer', 'flourish-pro'),
		'id' => 'abouttitlelogo',
		'std' => get_template_directory_uri().'/images/footer-logo.png',
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('About company Description', 'flourish-pro'),
		'desc' => __('about company description for footer', 'flourish-pro'),
		'id' => 'aboutusdescription',
		'std' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. mus eu pharetra ex. Etiam eget diam ligut anteugiat  Etiam eget diam ligut anteivamus feugiat.</p>',
		'type' => 'textarea');

	
	$options[] = array(
		'name' => __('Recent Posts Title', 'flourish-pro'),
		'desc' => __('Footer recent posts title.', 'flourish-pro'),
		'id' => 'letestpoststitle',
		'std' => 'Recent Posts',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Footer navigation Title', 'flourish-pro'),
		'desc' => __('footer navigation title.', 'flourish-pro'),
		'id' => 'footermenutitle',
		'std' => 'Usefull Links',
		'type' => 'text');		
	
	
	$options[] = array(
		'name' => __('Footer Service Hours', 'flourish-pro'),
		'desc' => __('Add footer service hours title here', 'flourish-pro'),
		'id' => 'servicehourstitle',
		'std' => 'Project Gallery',
		'type' => 'text');	
		
$options[] = array(
		'name' => __('Footer Gallery', 'flourish-pro'),
		'desc' => __('Footer Gallery.', 'flourish-pro'),
		'id' => 'servicesarea',
		'std' => '[photogallery filter="false" show="6"]',
		'type' => 'textarea');		
		
	
	$options[] = array(
		'name' => __('Contact Info', 'flourish-pro'),
		'desc' => __('Add footer get in touch title here', 'flourish-pro'),
		'id' => 'contacttitle',
		'std' => 'Get in Touch',
		'type' => 'text');	
				
		
	$options[] = array(	
		'desc' => __('Add company address here.', 'flourish-pro'),
		'id' => 'address',
		'std' => 'Address: &nbsp;&nbsp; 732/21 Second Street, Manchester, UK',
		'type' => 'textarea');
		
	$options[] = array(		
		'desc' => __('Add phone number here.', 'flourish-pro'),
		'id' => 'phone',
		'std' => 'Phone: &nbsp; 345-677-554',
		'type' => 'text');
		
		
		
	$options[] = array(
		'desc' => __('Add email address here.', 'flourish-pro'),
		'id' => 'email',
		'std' => 'Email: &nbsp;&nbsp; info@sitename.com',
		'type' => 'text');
		
	$options[] = array(		
		'desc' => __('Add website here.', 'flourish-pro'),
		'id' => 'website',
		'std' => 'Web:&nbsp;&nbsp;&nbsp;&nbsp; http://sitename.com',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Footer Social Icons', 'flourish-pro'),
		'desc' => __('social icons for footer', 'flourish-pro'),
		'id' => 'footersocialicon',
		'std' => '[social_area]
[social icon="fab fa-facebook-f" link="#"]
[social icon="fab fa-twitter" link="#"]
[social icon="fab fa-linkedin-in" link="#"]
[social icon="fab fa-google-plus-g" link="#"]				
[/social_area]',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Footer Copyright', 'flourish-pro'),
		'desc' => __('Copyright Text for your site.', 'flourish-pro'),
		'id' => 'copytext',
		'std' => 'Copyright &copy; 2019 <a href="'.esc_url('https://gracethemes.com/themes/logistics-wordpress-theme/').'" target="_blank">Flourish</a> &nbsp; | &nbsp; <a href="'.esc_url('https://gracethemes.com').'" target="_blank">Grace Themes</a>',
		'type' => 'textarea');
		
/*	$options[] = array(
		'desc' => __('Footer Text Link', 'flourish-pro'),
		'id' => 'ftlink',
		'std' => 'Design by <a href="'.esc_url('https://gracethemes.com').'" target="_blank">Grace Themes</a>',
		'type' => 'textarea',);*/
		
	$options[] = array(
		'desc' => __('Footer Back to Top Button', 'flourish-pro'),
		'id' => 'backtotop',
		'std' => '[back-to-top]',
		'type' => 'textarea',);

	//Short codes
	$options[] = array(
		'name' => __('Short Codes', 'flourish-pro'),
		'type' => 'heading');
	
	$options[] = array(
		'name' => __('Custom Video', 'flourish-pro'),
		'desc' => __('[custom-video youtubeid="enter here youtube id exa. E1QoFSQ50H0" cover="enter here cover photo"]', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Why People Choose Us', 'flourish-pro'),
		'desc' => __('[why_choos_us title="Economical Air Freight" description="fringilla mollis mag lInterdum et malesuada famante" icon="paste image path with http:"]', 'flourish-pro'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Service We Do', 'flourish-pro'),
		'desc' => __('[servicewedo image="IMAGE URL HERE" title="Industrial Design" description="SHORT DESCRIPTION" link="#"]', 'flourish-pro'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Our Process', 'flourish-pro'),
		'desc' => __('[our-process image="paste image path with http:" title="Deliver Your Things" number="4" bgcolor="#ffffff" color="#ffffff"]', 'flourish-pro'),
		'type' => 'info');	
				
	$options[] = array(
		'name' => __('Our Specialties', 'flourish-pro'),
		'desc' => __('[our-specialties color="#353535" icon="far fa-building" title="ADD TITLE HERE" content="DESCRIPTION HERE" url="#"]', 'flourish-pro'),
		'type' => 'info');	

		
	$options[] = array(
		'name' => __('List style', 'flourish-pro'),
		'desc' => __('
[list color="#ffffff"]
	<li>Etiam nulla augue, feugiat at maximus et, laoreet</li>
[/list]', 'flourish-pro'),
		'type' => 'info');	
			
	$options[] = array(
		'name' => __('Counter', 'flourish-pro'),
		'desc' => __('[counter value="356" title="Happy Customers" icon="paste image path with http:"]', 'flourish-pro'),
		'type' => 'info');
					
	$options[] = array(
		'name' => __('Footer contact detail', 'flourish-pro'),
		'desc' => __('[contact-details icon="fas fa-phone-volume" title="Phone:" info="(719) 445 - 2808"][contact-details icon="fas fa-map-marker-alt" title="Address:" info="4578 Marmora Road"][contact-details icon="far fa-envelope" title="E-mail:" info="info@sitename.com"]', 'flourish-pro'),
		'type' => 'info');
	
	$options[] = array(
		'name' => __('Skills', 'flourish-pro'),
		'desc' => __('[skill title="enter title here" bgcolor="#ff9c00" percent="80"]	<br />	
[skill title="enter title here" bgcolor="#ff9c00" percent="80"]	<br />	
[skill title="enter title here" bgcolor="#ff9c00" percent="80"]	', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Photo Gallery', 'flourish-pro'),
		'desc' => __('[photogallery filter="false" show="8"]', 'flourish-pro'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Section Sub Title', 'flourish-pro'),
		'desc' => __('[section-sub-title align="" title="enter title here"]', 'flourish-pro'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Section Main Title', 'flourish-pro'),
		'desc' => __('[section-main-title align="" title="enter title here"]', 'flourish-pro'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Testimonials Rotator', 'flourish-pro'),
		'desc' => __('[testimonials]', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('All Testimonials Listing', 'flourish-pro'),
		'desc' => __('[testimonials-listing show="10"]', 'flourish-pro'),
		'type' => 'info');	
		
		
	$options[] = array(
		'name' => __('Contact Form', 'flourish-pro'),
		'desc' => __('[contactform to_email="test@example.com" title="Contact Form"] 
', 'flourish-pro'),
		'type' => 'info');

	$options[] = array(
		'name' => __('Our Team', 'flourish-pro'),
		'desc' => __('[our-team show="-"]', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Our Team', 'flourish-pro'),
		'desc' => __('[our-team-4col show="-"]', 'flourish-pro'),
		'type' => 'info');			
		
	$options[] = array(
		'name' => __('Latest News', 'flourish-pro'),
		'desc' => __('[latest-news showposts="4" comment="show" date="show" author="show"]', 'flourish-pro'),
		'type' => 'info');	
		
	$options[] = array(
		'name' => __('Custom Button', 'flourish-pro'),
		'desc' => __('[button align="center" name="View Gallery" link="#" target=""]', 'flourish-pro'),
		'type' => 'info');		
		
	$options[] = array(
		'name' => __('Search Form', 'flourish-pro'),
		'desc' => __('[searchform]', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Social Icons ( Note: More social icons can be found at: https://fontawesome.com/icons)', 'flourish-pro'),
		'desc' => __('[social_area]<br />
			[social icon="fab fa-facebook-f" link="#"]<br />
			[social icon="fab fa-twitter" link="#"]<br />
			[social icon="fab fa-linkedin-in" link="#"]<br />
			[social icon="fab fa-google-plus-g" link="#"]<br />
		[/social_area]', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('2 Column Content', 'flourish-pro'),
		'desc' => __('<pre>
[column_content type="one_half"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_half_last"]
	Column 2 Content goes here...
[/column_content]
</pre>', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('3 Column Content', 'flourish-pro'),
		'desc' => __('<pre>
[column_content type="one_third"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_third"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_third_last"]
	Column 3 Content goes here...
[/column_content]
</pre>', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('4 Column Content', 'flourish-pro'),
		'desc' => __('<pre>
[column_content type="one_fourth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fourth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fourth_last"]
	Column 4 Content goes here...
[/column_content]
</pre>', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('5 Column Content', 'flourish-pro'),
		'desc' => __('<pre>
[column_content type="one_fifth"]
	Column 1 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 2 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 3 Content goes here...
[/column_content]

[column_content type="one_fifth"]
	Column 4 Content goes here...
[/column_content]

[column_content type="one_fifth_last"]
	Column 5 Content goes here...
[/column_content]
</pre>', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('Tabs', 'flourish-pro'),
		'desc' => __('<pre>
[tabs]
	[tab title="TAB TITLE 1"]
		TAB CONTENT 1
	[/tab]
	[tab title="TAB TITLE 2"]
		TAB CONTENT 2
	[/tab]
	[tab title="TAB TITLE 3"]
		TAB CONTENT 3
	[/tab]
[/tabs]
</pre>', 'flourish-pro'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Toggle Content', 'flourish-pro'),
		'desc' => __('<pre>
[toggle_content title="Toggle Title 1"]
	Toggle content 1...
[/toggle_content]
[toggle_content title="Toggle Title 2"]
	Toggle content 2...
[/toggle_content]
[toggle_content title="Toggle Title 3"]
	Toggle content 3...
[/toggle_content]
</pre>', 'flourish-pro'),
		'type' => 'info');


	$options[] = array(
		'name' => __('Accordion Content', 'flourish-pro'),
		'desc' => __('<pre>
[accordion]
	[accordion_content title="ACCORDION TITLE 1"]
		ACCORDION CONTENT 1
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 2"]
		ACCORDION CONTENT 2
	[/accordion_content]
	[accordion_content title="ACCORDION TITLE 3"]
		ACCORDION CONTENT 3
	[/accordion_content]
[/accordion]
</pre>', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Clear', 'flourish-pro'),
		'desc' => __('<pre>
[clear]
</pre>', 'flourish-pro'),
		'type' => 'info');	

	$options[] = array(
		'name' => __('HR / Horizontal separation line', 'flourish-pro'),
		'desc' => __('<pre>
[hr] or &lt;hr&gt;
</pre>', 'flourish-pro'),
		'type' => 'info');
		
	$options[] = array(
		'name' => __('Subtitle', 'flourish-pro'),
		'desc' => __('[subtitle color="#111111" size="15px" align="" description="short descriptio here"]', 'flourish-pro'),
		'type' => 'info');	
	
	$options[] = array(
		'name' => __('Scroll to Top', 'flourish-pro'),
		'desc' => __('[back-to-top] 
', 'flourish-pro'),
		'type' => 'info');

	return $options;
}